"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldSidebar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _unifiedFieldList = require("@kbn/unified-field-list");
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/use_field_sidebar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useFieldSidebar = ({
  dataView,
  columns,
  setColumns
}) => {
  const services = (0, _use_kibana.useKibana)().services;
  return (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_unifiedFieldList.UnifiedFieldListSidebarContainer, {
      services: {
        core: services,
        ...services
      },
      dataView: dataView,
      workspaceSelectedFieldNames: columns,
      allFields: dataView.fields,
      onAddFieldToWorkspace: field => {
        setColumns(prevColumns => [...(prevColumns.length === 0 ? ['@timestamp'] : prevColumns), field.name]);
      },
      onRemoveFieldFromWorkspace: field => {
        setColumns(prevColumns => prevColumns.filter(c => c !== field.name));
      },
      getCreationOptions: () => ({
        originatingApp: 'observability'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 7
      }
    });
  }, [columns, dataView, services, setColumns]);
};
exports.useFieldSidebar = useFieldSidebar;