"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupByCardinalityFilters = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGroupByCardinalityFilters = ({
  serviceName,
  environment,
  transactionType,
  transactionName
}) => {
  const serviceNameFilter = serviceName && serviceName !== _sloSchema.ALL_VALUE ? {
    meta: {
      disabled: false,
      negate: false,
      alias: null,
      key: 'service.name',
      params: serviceName,
      type: 'phrases'
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    },
    query: {
      bool: {
        minimum_should_match: 1,
        should: {
          match_phrase: {
            'service.name': serviceName
          }
        }
      }
    }
  } : null;
  const environmentFilter = environment && environment !== _sloSchema.ALL_VALUE ? {
    meta: {
      disabled: false,
      negate: false,
      alias: null,
      key: 'service.environment',
      params: environment,
      type: 'phrases'
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    },
    query: {
      bool: {
        minimum_should_match: 1,
        should: {
          match_phrase: {
            'service.environment': environment
          }
        }
      }
    }
  } : null;
  const transactionTypeFilter = transactionType && transactionType !== _sloSchema.ALL_VALUE ? {
    meta: {
      disabled: false,
      negate: false,
      alias: null,
      key: 'transaction.type',
      params: transactionType,
      type: 'phrases'
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    },
    query: {
      bool: {
        minimum_should_match: 1,
        should: {
          match_phrase: {
            'transaction.type': transactionType
          }
        }
      }
    }
  } : null;
  const transactionNameFilter = transactionName && transactionName !== _sloSchema.ALL_VALUE ? {
    meta: {
      disabled: false,
      negate: false,
      alias: null,
      key: 'transaction.name',
      params: transactionName,
      type: 'phrases'
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    },
    query: {
      bool: {
        minimum_should_match: 1,
        should: {
          match_phrase: {
            'transaction.name': transactionName
          }
        }
      }
    }
  } : null;
  return [serviceNameFilter, environmentFilter, transactionTypeFilter, transactionNameFilter].filter(value => !!value);
};
exports.getGroupByCardinalityFilters = getGroupByCardinalityFilters;