"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditFormIndicatorSection = SloEditFormIndicatorSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _constants = require("../constants");
var _use_unregister_fields = require("../hooks/use_unregister_fields");
var _apm_availability_indicator_type_form = require("./indicator_section/apm_availability/apm_availability_indicator_type_form");
var _apm_latency_indicator_type_form = require("./indicator_section/apm_latency/apm_latency_indicator_type_form");
var _custom_kql_indicator_type_form = require("./indicator_section/custom_kql/custom_kql_indicator_type_form");
var _custom_metric_type_form = require("./indicator_section/custom_metric/custom_metric_type_form");
var _histogram_indicator_type_form = require("./indicator_section/histogram/histogram_indicator_type_form");
var _synthetics_availability_indicator_type_form = require("./indicator_section/synthetics_availability/synthetics_availability_indicator_type_form");
var _timeslice_metric_indicator = require("./indicator_section/timeslice_metric/timeslice_metric_indicator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/slo_edit_form_indicator_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloEditFormIndicatorSection({
  isEditMode
}) {
  const {
    control,
    watch
  } = (0, _reactHookForm.useFormContext)();
  (0, _use_unregister_fields.useUnregisterFields)({
    isEditMode
  });
  const indicatorType = watch('indicator.type');
  const indicatorTypeForm = (0, _react.useMemo)(() => {
    switch (indicatorType) {
      case 'sli.kql.custom':
        return /*#__PURE__*/_react.default.createElement(_custom_kql_indicator_type_form.CustomKqlIndicatorTypeForm, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 16
          }
        });
      case 'sli.apm.transactionDuration':
        return /*#__PURE__*/_react.default.createElement(_apm_latency_indicator_type_form.ApmLatencyIndicatorTypeForm, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 16
          }
        });
      case 'sli.apm.transactionErrorRate':
        return /*#__PURE__*/_react.default.createElement(_apm_availability_indicator_type_form.ApmAvailabilityIndicatorTypeForm, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 42,
            columnNumber: 16
          }
        });
      case 'sli.synthetics.availability':
        return /*#__PURE__*/_react.default.createElement(_synthetics_availability_indicator_type_form.SyntheticsAvailabilityIndicatorTypeForm, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 44,
            columnNumber: 16
          }
        });
      case 'sli.metric.custom':
        return /*#__PURE__*/_react.default.createElement(_custom_metric_type_form.CustomMetricIndicatorTypeForm, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 46,
            columnNumber: 16
          }
        });
      case 'sli.histogram.custom':
        return /*#__PURE__*/_react.default.createElement(_histogram_indicator_type_form.HistogramIndicatorTypeForm, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 48,
            columnNumber: 16
          }
        });
      case 'sli.metric.timeslice':
        return /*#__PURE__*/_react.default.createElement(_timeslice_metric_indicator.TimesliceMetricIndicatorTypeForm, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 16
          }
        });
      default:
        (0, _std.assertNever)(indicatorType);
    }
  }, [indicatorType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    style: {
      maxWidth: _constants.MAX_WIDTH
    },
    "data-test-subj": "sloEditFormIndicatorSection",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, !isEditMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: indicatorLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "indicator.type",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, field, {
      required: true,
      "data-test-subj": "sloFormIndicatorTypeSelect",
      options: _constants.SLI_OPTIONS,
      "aria-label": indicatorLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 17
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  })), indicatorTypeForm);
}
const indicatorLabel = _i18n.i18n.translate('xpack.slo.sloEdit.definition.sliType', {
  defaultMessage: 'Choose the SLI type'
});