"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditPage = SloEditPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../../components/header_menu/header_menu");
var _use_fetch_slo_details = require("../../hooks/use_fetch_slo_details");
var _use_kibana = require("../../hooks/use_kibana");
var _use_license = require("../../hooks/use_license");
var _use_permissions = require("../../hooks/use_permissions");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _slo_edit_form = require("./components/slo_edit_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/slo_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloEditPage() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    serverless
  } = (0, _use_kibana.useKibana)().services;
  const {
    sloId
  } = (0, _reactRouterDom.useParams)();
  const {
    data: slo,
    isLoading: isLoadingSlo
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId
  });
  const isEditMode = Boolean(sloId);
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasRightLicense = hasAtLeast('platinum');
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.slos),
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.sloLabel', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'slo'
  }, ...(!!slo ? [{
    href: basePath.prepend(_paths.paths.sloDetails(slo.id, slo.instanceId)),
    text: slo.name
  }] : []), {
    text: sloId ? _i18n.i18n.translate('xpack.slo.breadcrumbs.sloEditLabel', {
      defaultMessage: 'Edit'
    }) : _i18n.i18n.translate('xpack.slo.breadcrumbs.sloCreateLabel', {
      defaultMessage: 'Create'
    })
  }], {
    serverless
  });
  (0, _react.useEffect)(() => {
    if (hasRightLicense === false || (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllReadRequested) === false) {
      navigateToUrl(basePath.prepend(_paths.paths.slosWelcome));
    }
    if ((permissions === null || permissions === void 0 ? void 0 : permissions.hasAllWriteRequested) === false) {
      navigateToUrl(basePath.prepend(_paths.paths.slos));
    }
  }, [hasRightLicense, permissions, navigateToUrl, basePath]);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: slo ? _i18n.i18n.translate('xpack.slo.sloEditPageTitle', {
        defaultMessage: 'Edit SLO'
      }) : _i18n.i18n.translate('xpack.slo.sloCreatePageTitle', {
        defaultMessage: 'Create new SLO'
      }),
      bottomBorder: false
    },
    "data-test-subj": "slosEditPage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), isEditMode && isLoadingSlo ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    "data-test-subj": "sloEditLoadingSpinner",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_slo_edit_form.SloEditForm, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }));
}