"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCardItemBadges = SloCardItemBadges;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _slo_badges = require("../../../../components/slo/slo_badges");
var _slo_active_alerts_badge = require("../../../../components/slo/slo_badges/slo_active_alerts_badge");
var _slo_tags_badge = require("../../../../components/slo/slo_badges/slo_tags_badge");
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _slo_badges2 = require("../badges/slo_badges");
var _slo_remote_badge = require("../badges/slo_remote_badge");
var _slo_rules_badge = require("../badges/slo_rules_badge");
var _slo_card_item_instance_badge = require("./slo_card_item_instance_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/card_view/slo_card_item_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloCardItemBadges({
  slo,
  activeAlerts,
  rules,
  handleCreateRule
}) {
  const {
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const handleTagClick = tag => onStateChange({
    kqlQuery: `slo.tags: "${tag}"`
  });
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: ({
      euiTheme
    }) => (0, _react.css)`
        display: inline-block;
        margin-top: ${euiTheme.size.xs};
      `,
    onClick: evt => {
      evt.stopPropagation();
    },
    "aria-hidden": "true",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, !slo.summary ? /*#__PURE__*/_react2.default.createElement(_slo_badges2.LoadingBadges, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_slo_badges.SloStateBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_slo_active_alerts_badge.SloActiveAlertsBadge, {
    slo: slo,
    activeAlerts: activeAlerts,
    viewMode: "compact",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_slo_card_item_instance_badge.SLOCardItemInstanceBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_slo_rules_badge.SloRulesBadge, {
    rules: rules,
    onClick: handleCreateRule,
    isRemote: !!slo.remote,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_slo_remote_badge.SloRemoteBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_slo_tags_badge.SloTagsBadge, {
    slo: slo,
    onClick: handleTagClick,
    defaultVisibleTags: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 13
    }
  }))));
}