"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLOGroupings = SLOGroupings;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/common/slo_groupings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SLOGroupings({
  slo,
  direction = 'row',
  gutterSize = 's',
  truncate = true
}) {
  const groups = Object.entries((slo === null || slo === void 0 ? void 0 : slo.groupings) || []);
  const shouldTruncate = truncate && groups.length > 3;
  const firstThree = shouldTruncate ? groups.slice(0, 3) : groups;
  const rest = shouldTruncate ? groups.slice(3, groups.length) : [];
  const buttonCss = (0, _react2.css)`
    &:hover {
      text-decoration: none;
    }
  `;
  if (!groups.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldTruncate ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "sloGroupingsAccordion",
    arrowDisplay: "right",
    buttonElement: "div",
    buttonProps: {
      css: buttonCss
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: direction === 'column' ? 'flexStart' : 'center',
      gutterSize: "s",
      direction: direction,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(Entries, {
      entries: firstThree,
      direction: direction,
      gutterSize: gutterSize,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 21
      }
    }, rest.length && /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "accordion",
      flush: "left",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 27
      }
    }, `(${_i18n.i18n.translate('xpack.slo.andLabel', {
      defaultMessage: 'and {count, plural, one {# instance} other {# instances}}',
      values: {
        count: rest.length
      }
    })})`))))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Entries, {
    entries: rest,
    direction: direction,
    gutterSize: gutterSize,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  })))) : /*#__PURE__*/_react.default.createElement(Entries, {
    entries: truncate ? firstThree : groups,
    gutterSize: gutterSize,
    direction: direction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }));
}
function Entries({
  entries,
  direction,
  gutterSize = 's'
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: gutterSize,
    direction: direction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, entries.map(([key, value]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: key,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, `${key}: `, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: String(value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "sloInstanceCopy",
    css: {
      fontWeight: euiTheme.font.weight.semiBold
    },
    color: "text",
    onClick: e => {
      e.stopPropagation();
      copy();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }, value)))))));
}