"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupListView = GroupListView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _paths = require("../../../../../common/locators/paths");
var _use_fetch_slo_list = require("../../../../hooks/use_fetch_slo_list");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_slo_summary = require("../../hooks/use_slo_summary");
var _slos_view = require("../slos_view");
var _use_group_name = require("./hooks/use_group_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/grouped_slos/group_list_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GroupListView({
  group,
  kqlQuery,
  view,
  sort,
  direction,
  groupBy,
  summary,
  filters
}) {
  var _summary$worst$slo, _summary$worst$slo2, _worst$slo, _worst$slo2;
  const groupQuery = `"${groupBy}": "${group}"`;
  const query = kqlQuery ? `${groupQuery} and ${kqlQuery}` : groupQuery;
  const groupName = (0, _use_group_name.useGroupName)(groupBy, group, summary);
  const [page, setPage] = (0, _react.useState)(0);
  const [accordionState, setAccordionState] = (0, _react.useState)('closed');
  const onToggle = isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setAccordionState(newState);
  };
  const isAccordionOpen = accordionState === 'open';
  const {
    http: {
      basePath
    }
  } = (0, _use_kibana.useKibana)().services;
  const [itemsPerPage, setItemsPerPage] = (0, _react.useState)(10);
  const {
    isLoading,
    isRefetching,
    isError,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    kqlQuery: query,
    sortBy: sort,
    sortDirection: direction,
    perPage: itemsPerPage,
    page: page + 1,
    filters,
    disabled: !isAccordionOpen
  });
  const {
    results = [],
    total = 0
  } = sloList !== null && sloList !== void 0 ? sloList : {};
  const handlePageClick = pageNumber => {
    setPage(pageNumber);
  };
  const worstSLI = (0, _use_slo_summary.useSloFormattedSLIValue)(summary === null || summary === void 0 ? void 0 : summary.worst.sliValue);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "sloGroupViewPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(MemoEuiAccordion, {
    forceState: accordionState,
    onToggle: onToggle,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 21
      }
    }, groupName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 19
      }
    }, "(", summary === null || summary === void 0 ? void 0 : summary.total, ")"))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }, summary.violated > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.slo.group.totalViolated', {
      defaultMessage: '{total} Violated',
      values: {
        total: summary === null || summary === void 0 ? void 0 : summary.violated
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: 'success',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.slo.group.totalHealthy', {
      defaultMessage: '{total} Healthy',
      values: {
        total: summary === null || summary === void 0 ? void 0 : summary.healthy
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }, group === 'NO_DATA' ? /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.slo.group.worstPerforming', {
      defaultMessage: 'Worst performing: '
    }), /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.slo.group.worstPerforming.notAvailable', {
      defaultMessage: 'N/A'
    }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 27
        }
      }, _i18n.i18n.translate('xpack.slo.group.totalSloViolatedTooltip', {
        defaultMessage: 'SLO: {name}',
        values: {
          name: summary === null || summary === void 0 ? void 0 : (_summary$worst$slo = summary.worst.slo) === null || _summary$worst$slo === void 0 ? void 0 : _summary$worst$slo.name
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 27
        }
      }, _i18n.i18n.translate('xpack.slo.group.totalSloViolatedTooltip.instance', {
        defaultMessage: 'Instance: {instance}',
        values: {
          instance: summary === null || summary === void 0 ? void 0 : (_summary$worst$slo2 = summary.worst.slo) === null || _summary$worst$slo2 === void 0 ? void 0 : _summary$worst$slo2.instanceId
        }
      }))),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "o11yGroupListViewLink",
      href: basePath.prepend(_paths.paths.sloDetails((_worst$slo = summary.worst.slo) === null || _worst$slo === void 0 ? void 0 : _worst$slo.id, (_worst$slo2 = summary.worst.slo) === null || _worst$slo2 === void 0 ? void 0 : _worst$slo2.instanceId)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.slo.group.worstPerforming', {
      defaultMessage: 'Worst performing: '
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: (summary === null || summary === void 0 ? void 0 : summary.worst.status) !== 'HEALTHY' ? 'danger' : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 27
      }
    }, worstSLI)))))),
    id: group,
    initialIsOpen: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, isAccordionOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_slos_view.SlosView, {
    sloList: results,
    loading: isLoading || isRefetching,
    error: isError,
    view: view,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  }), total > 0 && total > itemsPerPage ? /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    pageCount: Math.ceil(total / itemsPerPage),
    activePage: page,
    onChangePage: handlePageClick,
    itemsPerPage: itemsPerPage,
    onChangeItemsPerPage: perPage => {
      setPage(0);
      setItemsPerPage(perPage);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 19
    }
  }) : null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }));
}
const MemoEuiAccordion = /*#__PURE__*/(0, _react.memo)(_eui.EuiAccordion);