"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NONE_LABEL = exports.GROUP_TITLE = void 0;
exports.SloGroupBy = SloGroupBy;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_get_settings = require("../../slo_settings/hooks/use_get_settings");
var _slo_context_menu = require("./slo_context_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/slo_list_group_by.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloGroupBy({
  onStateChange,
  state,
  loading
}) {
  var _groupByOptions$find;
  const [isGroupByPopoverOpen, setIsGroupByPopoverOpen] = (0, _react.useState)(false);
  const groupBy = state.groupBy;
  const {
    data: settings
  } = (0, _use_get_settings.useGetSettings)();
  const hasRemoteEnabled = settings && (settings.useAllRemoteClusters || settings.selectedRemoteClusters.length > 0);
  const handleChangeGroupBy = value => {
    onStateChange({
      page: 0,
      groupBy: value
    });
  };
  const groupByOptions = [{
    label: NONE_LABEL,
    checked: groupBy === 'ungrouped',
    value: 'ungrouped',
    onClick: () => {
      handleChangeGroupBy('ungrouped');
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.groupBy.tags', {
      defaultMessage: 'Tags'
    }),
    checked: groupBy === 'slo.tags',
    value: 'slo.tags',
    onClick: () => {
      handleChangeGroupBy('slo.tags');
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.groupBy.status', {
      defaultMessage: 'Status'
    }),
    checked: groupBy === 'status',
    value: 'status',
    onClick: () => {
      handleChangeGroupBy('status');
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.groupBy.sliType', {
      defaultMessage: 'SLI type'
    }),
    checked: groupBy === 'slo.indicator.type',
    value: 'slo.indicator.type',
    onClick: () => {
      handleChangeGroupBy('slo.indicator.type');
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.groupBy.sloId', {
      defaultMessage: 'SLO definition id'
    }),
    checked: groupBy === 'slo.id',
    value: 'slo.id',
    onClick: () => {
      handleChangeGroupBy('slo.id');
    }
  }, {
    label: _i18n.i18n.translate('xpack.slo.list.groupBy.sloInstanceId', {
      defaultMessage: 'SLO instance id'
    }),
    checked: groupBy === 'slo.instanceId',
    value: 'slo.instanceId',
    onClick: () => {
      handleChangeGroupBy('slo.instanceId');
    }
  }];
  if (hasRemoteEnabled) {
    groupByOptions.push({
      label: _i18n.i18n.translate('xpack.slo.list.groupBy.remoteCluster', {
        defaultMessage: 'Remote cluster'
      }),
      checked: groupBy === '_index',
      value: '_index',
      onClick: () => {
        handleChangeGroupBy('_index');
      }
    });
  }
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    key: "group_title_panel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, GROUP_TITLE))), ...groupByOptions.map(option => /*#__PURE__*/_react.default.createElement(_slo_context_menu.ContextMenuItem, {
    option: option,
    onClosePopover: () => setIsGroupByPopoverOpen(false),
    key: option.value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }))];
  return /*#__PURE__*/_react.default.createElement(_slo_context_menu.SLOContextMenu, {
    items: items,
    id: "groupBy",
    selected: ((_groupByOptions$find = groupByOptions.find(option => option.value === groupBy)) === null || _groupByOptions$find === void 0 ? void 0 : _groupByOptions$find.label) || NONE_LABEL,
    isPopoverOpen: isGroupByPopoverOpen,
    setIsPopoverOpen: setIsGroupByPopoverOpen,
    label: GROUP_TITLE,
    loading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  });
}
const NONE_LABEL = exports.NONE_LABEL = _i18n.i18n.translate('xpack.slo.list.groupBy.sliIndicator', {
  defaultMessage: 'None'
});
const GROUP_TITLE = exports.GROUP_TITLE = _i18n.i18n.translate('xpack.slo.groupPopover.group.title', {
  defaultMessage: 'Group by'
});