"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListSearchBar = SloListSearchBar;
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _react2 = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _use_crud_loading = require("../hooks/use_crud_loading");
var _use_summary_dataview = require("../hooks/use_summary_dataview");
var _use_url_search_state = require("../hooks/use_url_search_state");
var _quick_filters = require("./common/quick_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/slo_list_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloListSearchBar() {
  const {
    data: {
      query
    },
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const isSloCrudLoading = (0, _use_crud_loading.useSloCrudLoading)();
  const {
    isLoading: isDataViewLoading,
    data: dataView
  } = (0, _use_summary_dataview.useSloSummaryDataView)();
  (0, _react2.useEffect)(() => {
    const sub = query.state$.subscribe(() => {
      const queryState = query.getState();
      onStateChange({
        kqlQuery: String(queryState.query.query),
        filters: queryState.filters
      });
    });
    return () => sub.unsubscribe();
  }, [onStateChange, query]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        .uniSearchBar {
          padding: 0;
        }
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(SearchBar, {
    appName: _public.observabilityAppId,
    placeholder: PLACEHOLDER,
    indexPatterns: dataView ? [dataView] : [],
    isDisabled: isSloCrudLoading,
    renderQueryInputAppend: () => /*#__PURE__*/_react2.default.createElement(_quick_filters.QuickFilters, {
      dataView: dataView,
      initialState: state,
      loading: isSloCrudLoading || isDataViewLoading,
      onStateChange: onStateChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }),
    filters: state.filters,
    onFiltersUpdated: newFilters => {
      onStateChange({
        filters: newFilters
      });
    },
    onQuerySubmit: ({
      query: value
    }) => {
      onStateChange({
        kqlQuery: String(value === null || value === void 0 ? void 0 : value.query),
        lastRefresh: Date.now()
      });
    },
    query: {
      query: String(state.kqlQuery),
      language: 'kuery'
    },
    showSubmitButton: true,
    showDatePicker: false,
    showQueryInput: true,
    disableQueryLanguageSwitcher: true,
    allowSavingQueries: true,
    onClearSavedQuery: () => {},
    onSavedQueryUpdated: savedQuery => {
      onStateChange({
        filters: savedQuery.attributes.filters,
        kqlQuery: String(savedQuery.attributes.query.query)
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }));
}
const PLACEHOLDER = _i18n.i18n.translate('xpack.slo.list.search', {
  defaultMessage: 'Search your SLOs ...'
});