"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewItem = OverviewItem;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/slos_overview/overview_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OverviewItem({
  title,
  description,
  titleColor,
  isLoading,
  query,
  tooltip,
  onClick
}) {
  const {
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltip,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: title,
    description: description,
    titleColor: titleColor,
    reverse: true,
    isLoading: isLoading,
    onClick: () => {
      if (onClick) {
        onClick();
        return;
      }
      onStateChange({
        kqlQuery: query
      });
    },
    css: {
      cursor: 'pointer'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })));
}