"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSloHealthRoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _services = require("../../services");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSloHealthRoute = exports.fetchSloHealthRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /internal/observability/slos/_health',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_read']
    }
  },
  params: _sloSchema.fetchSLOHealthParamsSchema,
  handler: async ({
    request,
    logger,
    params,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient
    } = await getScopedClients({
      request,
      logger
    });
    const getSLOHealth = new _services.GetSLOHealth(scopedClusterClient);
    return await getSLOHealth.execute(params.body);
  }
});