"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTempSummaryDocument = createTempSummaryDocument;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTempSummaryDocument(slo, spaceId, basePath) {
  var _apmParams$environmen, _apmParams$service, _apmParams$transactio, _apmParams$transactio2, _slo$objective$timesl, _slo$objective$timesl2, _slo$objective$timesl3, _slo$createdBy, _slo$updatedBy, _basePath$publicBaseU;
  const apmParams = 'environment' in slo.indicator.params ? slo.indicator.params : null;
  const doc = {
    // apm specific fields
    service: {
      environment: (_apmParams$environmen = apmParams === null || apmParams === void 0 ? void 0 : apmParams.environment) !== null && _apmParams$environmen !== void 0 ? _apmParams$environmen : null,
      name: (_apmParams$service = apmParams === null || apmParams === void 0 ? void 0 : apmParams.service) !== null && _apmParams$service !== void 0 ? _apmParams$service : null
    },
    transaction: {
      name: (_apmParams$transactio = apmParams === null || apmParams === void 0 ? void 0 : apmParams.transactionName) !== null && _apmParams$transactio !== void 0 ? _apmParams$transactio : null,
      type: (_apmParams$transactio2 = apmParams === null || apmParams === void 0 ? void 0 : apmParams.transactionType) !== null && _apmParams$transactio2 !== void 0 ? _apmParams$transactio2 : null
    },
    // synthetics specific fields
    monitor: {
      name: null,
      config_id: null
    },
    observer: {
      name: null,
      geo: {
        name: null
      }
    },
    slo: {
      // 8.14 adds indicator.params through transform summary pipeline, i.e. indicator.params might be undefined
      indicator: slo.indicator,
      timeWindow: {
        duration: slo.timeWindow.duration.format(),
        type: slo.timeWindow.type
      },
      groupBy: !!slo.groupBy ? slo.groupBy : _sloSchema.ALL_VALUE,
      groupings: {},
      instanceId: _sloSchema.ALL_VALUE,
      name: slo.name,
      description: slo.description,
      id: slo.id,
      budgetingMethod: slo.budgetingMethod,
      revision: slo.revision,
      objective: {
        target: slo.objective.target,
        timesliceTarget: (_slo$objective$timesl = slo.objective.timesliceTarget) !== null && _slo$objective$timesl !== void 0 ? _slo$objective$timesl : undefined,
        timesliceWindow: (_slo$objective$timesl2 = (_slo$objective$timesl3 = slo.objective.timesliceWindow) === null || _slo$objective$timesl3 === void 0 ? void 0 : _slo$objective$timesl3.format()) !== null && _slo$objective$timesl2 !== void 0 ? _slo$objective$timesl2 : undefined
      },
      tags: slo.tags,
      createdAt: slo.createdAt.toISOString(),
      // added in 8.14, i.e. might be undefined
      updatedAt: slo.updatedAt.toISOString(),
      // added in 8.14, i.e. might be undefined
      // Added in 8.18
      createdBy: (_slo$createdBy = slo.createdBy) !== null && _slo$createdBy !== void 0 ? _slo$createdBy : '',
      updatedBy: (_slo$updatedBy = slo.updatedBy) !== null && _slo$updatedBy !== void 0 ? _slo$updatedBy : ''
    },
    goodEvents: 0,
    totalEvents: 0,
    errorBudgetEstimated: false,
    errorBudgetRemaining: 1,
    errorBudgetConsumed: 0,
    errorBudgetInitial: 1 - slo.objective.target,
    sliValue: -1,
    statusCode: 0,
    status: 'NO_DATA',
    isTempDoc: true,
    spaceId,
    kibanaUrl: (_basePath$publicBaseU = basePath.publicBaseUrl) !== null && _basePath$publicBaseU !== void 0 ? _basePath$publicBaseU : '',
    // added in 8.14, i.e. might be undefined
    summaryUpdatedAt: null,
    latestSliTimestamp: null,
    // Added in 8.15
    fiveMinuteBurnRate: {
      totalEvents: 0,
      goodEvents: 0,
      value: 0
    },
    oneHourBurnRate: {
      totalEvents: 0,
      goodEvents: 0,
      value: 0
    },
    oneDayBurnRate: {
      totalEvents: 0,
      goodEvents: 0,
      value: 0
    }
  };
  return doc;
}