"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTransformGenerators = createTransformGenerators;
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTransformGenerators(spaceId, dataViewsService, isServerless) {
  return {
    'sli.apm.transactionDuration': new _.ApmTransactionDurationTransformGenerator(spaceId, dataViewsService, isServerless),
    'sli.apm.transactionErrorRate': new _.ApmTransactionErrorRateTransformGenerator(spaceId, dataViewsService, isServerless),
    'sli.synthetics.availability': new _.SyntheticsAvailabilityTransformGenerator(spaceId, dataViewsService, isServerless),
    'sli.kql.custom': new _.KQLCustomTransformGenerator(spaceId, dataViewsService, isServerless),
    'sli.metric.custom': new _.MetricCustomTransformGenerator(spaceId, dataViewsService, isServerless),
    'sli.histogram.custom': new _.HistogramTransformGenerator(spaceId, dataViewsService, isServerless),
    'sli.metric.timeslice': new _.TimesliceMetricTransformGenerator(spaceId, dataViewsService, isServerless)
  };
}