"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeGlobalStateField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/policy_form/steps/step_settings/fields/include_global_state_field/include_global_state_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IncludeGlobalStateField = ({
  policy,
  onUpdate
}) => {
  const {
    config = {}
  } = policy;
  const onIncludeGlobalStateToggle = event => {
    var _config$featureStates;
    const {
      checked
    } = event.target;
    const hasFeatureStates = !(config !== null && config !== void 0 && (_config$featureStates = config.featureStates) !== null && _config$featureStates !== void 0 && _config$featureStates.includes(_constants.FEATURE_STATES_NONE_OPTION));
    onUpdate({
      includeGlobalState: checked,
      // if we ever include global state, we want to preselect featureStates for the users
      // so that we include all features as well.
      featureStates: checked && !hasFeatureStates ? [] : config.featureStates || []
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.includeGlobalStateDescriptionTitle",
      defaultMessage: "Include global state",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.includeGlobalStateDescription",
      defaultMessage: "Stores the global cluster state as part of the snapshot.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "globalStateToggle",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.policyIncludeGlobalStateLabel",
      defaultMessage: "Include global state",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }),
    checked: config.includeGlobalState === undefined || config.includeGlobalState,
    onChange: onIncludeGlobalStateToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  })));
};
exports.IncludeGlobalStateField = IncludeGlobalStateField;