"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshotStepLogistics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _lib = require("../../../../../../common/lib");
var _app_context = require("../../../../app_context");
var _lib2 = require("../../../lib");
var _data_stream_badge = require("../../../data_stream_badge");
var _data_streams_global_state_call_out = require("./data_streams_global_state_call_out");
var _data_streams_and_indices_list_help_text = require("./data_streams_and_indices_list_help_text");
var _system_indices_overwritten_callout = require("./system_indices_overwritten_callout");
var _feature_states_form_field = require("../../../feature_states_form_field");
var _styles = require("../../../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/restore_snapshot_form/steps/step_logistics/step_logistics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const styles = {
  indicesFieldWrapper: _styles.indicesFieldWrapperStyle
};
const RestoreSnapshotStepLogistics = ({
  snapshotDetails,
  restoreSettings,
  updateRestoreSettings,
  errors
}) => {
  var _csvToArray;
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const {
    indices: unfilteredSnapshotIndices,
    dataStreams: snapshotDataStreams = [],
    includeGlobalState: snapshotIncludeGlobalState,
    versionId,
    featureStates: snapshotIncludeFeatureStates
  } = snapshotDetails;
  const snapshotIndices = unfilteredSnapshotIndices.filter(index => !(0, _lib.isDataStreamBackingIndex)(index));
  const snapshotIndicesAndDataStreams = snapshotIndices.concat(snapshotDataStreams);
  const comboBoxOptions = (0, _lib2.orderDataStreamsAndIndices)({
    dataStreams: snapshotDataStreams.map(dataStream => ({
      label: dataStream,
      value: {
        isDataStream: true,
        name: dataStream
      }
    })),
    indices: snapshotIndices.map(index => ({
      label: index,
      value: {
        isDataStream: false,
        name: index
      }
    }))
  });
  const {
    indices: restoreIndices,
    renamePattern,
    renameReplacement,
    partial,
    includeGlobalState,
    featureStates,
    includeAliases
  } = restoreSettings;

  // States for choosing all indices, or a subset, including caching previously chosen subset list
  const [isAllIndicesAndDataStreams, setIsAllIndicesAndDataStreams] = (0, _react.useState)(!Boolean(restoreIndices));
  const [indicesAndDataStreamsOptions, setIndicesAndDataStreamsOptions] = (0, _react.useState)(() => (0, _lib2.orderDataStreamsAndIndices)({
    dataStreams: snapshotDataStreams.map(dataStream => ({
      label: dataStream,
      append: /*#__PURE__*/_react.default.createElement(_data_stream_badge.DataStreamBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 19
        }
      }),
      checked: isAllIndicesAndDataStreams ||
      // If indices is a string, we default to custom input mode, so we mark individual indices
      // as selected if user goes back to list mode
      typeof restoreIndices === 'string' || Array.isArray(restoreIndices) && restoreIndices.includes(dataStream) ? 'on' : undefined
    })),
    indices: snapshotIndices.map(index => ({
      label: index,
      checked: isAllIndicesAndDataStreams ||
      // If indices is a string, we default to custom input mode, so we mark individual indices
      // as selected if user goes back to list mode
      typeof restoreIndices === 'string' || Array.isArray(restoreIndices) && restoreIndices.includes(index) ? 'on' : undefined
    }))
  }));

  // State for using selectable indices list or custom patterns
  // Users with more than 100 indices will probably want to use an index pattern to select
  // them instead, so we'll default to showing them the index pattern input.
  const [selectIndicesMode, setSelectIndicesMode] = (0, _react.useState)(typeof restoreIndices === 'string' || snapshotIndicesAndDataStreams.length > 100 ? 'custom' : 'list');

  // State for custom patterns
  const [restoreIndexPatterns, setRestoreIndexPatterns] = (0, _react.useState)(typeof restoreIndices === 'string' ? restoreIndices.split(',') : []);

  // State for setting renaming indices patterns
  const [isRenamingIndices, setIsRenamingIndices] = (0, _react.useState)(Boolean(renamePattern || renameReplacement));

  // Caching state for togglable settings
  const [cachedRestoreSettings, setCachedRestoreSettings] = (0, _react.useState)({
    indices: [...snapshotIndicesAndDataStreams],
    renamePattern: '',
    renameReplacement: ''
  });
  const selectedFeatureStateOptions = (0, _react.useMemo)(() => {
    return featureStates === null || featureStates === void 0 ? void 0 : featureStates.map(feature => ({
      label: feature
    }));
  }, [featureStates]);
  const isFeatureStatesToggleEnabled = featureStates !== undefined && !(featureStates !== null && featureStates !== void 0 && featureStates.includes(_constants.FEATURE_STATES_NONE_OPTION));
  const onFeatureStatesToggleChange = event => {
    const {
      checked
    } = event.target;
    updateRestoreSettings({
      featureStates: checked ? [] : [_constants.FEATURE_STATES_NONE_OPTION]
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "snapshotRestoreStepLogistics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepLogisticsTitle",
    defaultMessage: "Restore details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: docLinks.links.snapshotRestore.restoreSnapshot,
    target: "_blank",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepLogistics.docsButtonLabel",
    defaultMessage: "Snapshot and Restore docs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  })))), snapshotDataStreams.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_data_streams_global_state_call_out.DataStreamsGlobalStateCallOut, {
    dataStreamsCount: snapshotDataStreams.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  })) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesTitle",
      defaultMessage: "Data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesDescription",
      defaultMessage: "Creates new data streams and indices if they don\u2019t exist. Opens existing indices, including backing indices for a data stream, if they are closed and have the same number of shards as the snapshot index.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.allDataStreamsAndIndicesLabel",
      defaultMessage: "All data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 17
      }
    }),
    checked: isAllIndicesAndDataStreams,
    onChange: e => {
      const isChecked = e.target.checked;
      setIsAllIndicesAndDataStreams(isChecked);
      if (isChecked) {
        updateRestoreSettings({
          indices: undefined
        });
      } else {
        updateRestoreSettings({
          indices: selectIndicesMode === 'custom' ? restoreIndexPatterns.join(',') : [...(cachedRestoreSettings.indices || [])]
        });
      }
    },
    "data-test-subj": "allDsAndIndicesToggle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 13
    }
  }), isAllIndicesAndDataStreams ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: styles.indicesFieldWrapper,
    label: selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.selectDataStreamsAndIndicesLabel",
      defaultMessage: "Select data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setSelectIndicesMode('custom');
        updateRestoreSettings({
          indices: restoreIndexPatterns.join(',')
        });
      },
      "data-test-subj": "restoreIndexPatternsButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.indicesToggleCustomLink",
      defaultMessage: "Use index patterns",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 29
      }
    })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.indicesPatternLabel",
      defaultMessage: "Index patterns",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 27
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setSelectIndicesMode('list');
        updateRestoreSettings({
          indices: cachedRestoreSettings.indices
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesToggleListLink",
      defaultMessage: "Select data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 29
      }
    })))),
    helpText: selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_data_streams_and_indices_list_help_text.DataStreamsAndIndicesListHelpText, {
      onSelectionChange: selection => {
        if (selection === 'all') {
          // TODO: Change this to setIndicesOptions() when https://github.com/elastic/eui/issues/2071 is fixed
          indicesAndDataStreamsOptions.forEach(option => {
            option.checked = 'on';
          });
          updateRestoreSettings({
            indices: [...snapshotIndicesAndDataStreams]
          });
          setCachedRestoreSettings({
            ...cachedRestoreSettings,
            indices: [...snapshotIndicesAndDataStreams]
          });
        } else {
          // TODO: Change this to setIndicesOptions() when https://github.com/elastic/eui/issues/2071 is fixed
          indicesAndDataStreamsOptions.forEach(option => {
            option.checked = undefined;
          });
          updateRestoreSettings({
            indices: []
          });
          setCachedRestoreSettings({
            ...cachedRestoreSettings,
            indices: []
          });
        }
      },
      selectedIndicesAndDataStreams: (_csvToArray = (0, _lib.csvToArray)(restoreIndices)) !== null && _csvToArray !== void 0 ? _csvToArray : [],
      indices: snapshotIndices,
      dataStreams: snapshotDataStreams,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 23
      }
    }) : null,
    isInvalid: Boolean(errors.indices),
    error: errors.indices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 17
    }
  }, selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    allowExclusions: false,
    options: indicesAndDataStreamsOptions,
    onChange: options => {
      const newSelectedIndices = [];
      options.forEach(({
        label,
        checked
      }) => {
        if (checked === 'on') {
          newSelectedIndices.push(label);
        }
      });
      setIndicesAndDataStreamsOptions(options);
      updateRestoreSettings({
        indices: [...newSelectedIndices]
      });
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        indices: [...newSelectedIndices]
      });
    },
    searchable: true,
    height: 300,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 21
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 25
    }
  }, search, list)) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: comboBoxOptions,
    renderOption: ({
      value
    }) => {
      return value !== null && value !== void 0 && value.isDataStream ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        justifyContent: "spaceBetween",
        alignItems: "center",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 389,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 395,
          columnNumber: 29
        }
      }, value.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 396,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_data_stream_badge.DataStreamBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 397,
          columnNumber: 31
        }
      }))) : value === null || value === void 0 ? void 0 : value.name;
    },
    placeholder: i18n.translate('xpack.snapshotRestore.restoreForm.stepLogistics.indicesPatternPlaceholder', {
      defaultMessage: 'Enter index patterns, i.e. logstash-*'
    }),
    selectedOptions: restoreIndexPatterns.map(pattern => ({
      label: pattern
    })),
    onCreateOption: pattern => {
      if (!pattern.trim().length) {
        return;
      }
      const newPatterns = [...restoreIndexPatterns, pattern];
      setRestoreIndexPatterns(newPatterns);
      updateRestoreSettings({
        indices: newPatterns.join(',')
      });
    },
    onChange: patterns => {
      const newPatterns = patterns.map(({
        label
      }) => label);
      setRestoreIndexPatterns(newPatterns);
      updateRestoreSettings({
        indices: newPatterns.join(',')
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 21
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 440,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 441,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesTitle",
      defaultMessage: "Rename data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 442,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesDescription",
      defaultMessage: "Renames data streams and indices on restore. Ensure that a matching index template exists for renamed data streams.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesLabel",
      defaultMessage: "Rename data streams and indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 461,
        columnNumber: 17
      }
    }),
    checked: isRenamingIndices,
    onChange: e => {
      const isChecked = e.target.checked;
      setIsRenamingIndices(isChecked);
      if (isChecked) {
        updateRestoreSettings({
          renamePattern: cachedRestoreSettings.renamePattern,
          renameReplacement: cachedRestoreSettings.renameReplacement
        });
      } else {
        updateRestoreSettings({
          renamePattern: undefined,
          renameReplacement: undefined
        });
      }
    },
    "data-test-subj": "restoreRenameToggle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 13
    }
  }), !isRenamingIndices ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 486,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 487,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 488,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renamePatternLabel",
      defaultMessage: "Capture pattern",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 491,
        columnNumber: 25
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renamePatternHelpText",
      defaultMessage: "Use regular expressions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 497,
        columnNumber: 25
      }
    }),
    isInvalid: Boolean(errors.renamePattern),
    error: errors.renamePattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 489,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: Boolean(errors.renamePattern),
    value: renamePattern,
    placeholder: "data_(.+)",
    onChange: e => {
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        renamePattern: e.target.value
      });
      updateRestoreSettings({
        renamePattern: e.target.value
      });
    },
    "data-test-subj": "capturePattern",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 505,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 522,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renameReplacementLabel",
      defaultMessage: "Replacement pattern",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 525,
        columnNumber: 25
      }
    }),
    isInvalid: Boolean(errors.renameReplacement),
    error: errors.renameReplacement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 523,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: Boolean(errors.renameReplacement),
    value: renameReplacement,
    placeholder: "restored_data_$1",
    onChange: e => {
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        renameReplacement: e.target.value
      });
      updateRestoreSettings({
        renameReplacement: e.target.value
      });
    },
    "data-test-subj": "replacementPattern",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 533,
      columnNumber: 23
    }
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 560,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 561,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.partialTitle",
      defaultMessage: "Partial restore",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 562,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.partialDescription",
      defaultMessage: "Allows restore of indices that don\u2019t have snapshots of all shards.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 570,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 558,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 577,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.partialLabel",
      defaultMessage: "Partial restore",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 580,
        columnNumber: 15
      }
    }),
    checked: partial === undefined ? false : partial,
    onChange: e => updateRestoreSettings({
      partial: e.target.checked
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 578,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 594,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 595,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateTitle",
      defaultMessage: "Restore global state",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 596,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateDescription",
      defaultMessage: "Restores the global cluster state as part of the snapshot.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 604,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 592,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: snapshotIncludeGlobalState ? null : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateDisabledDescription",
      defaultMessage: "Not available for this snapshot.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 615,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 611,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateLabel",
      defaultMessage: "Restore global state",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 624,
        columnNumber: 15
      }
    }),
    checked: includeGlobalState === undefined ? false : includeGlobalState,
    onChange: e => updateRestoreSettings({
      includeGlobalState: e.target.checked
    }),
    disabled: !snapshotIncludeGlobalState,
    "data-test-subj": "includeGlobalStateSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 622,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 640,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 641,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeFeatureStatesTitle",
      defaultMessage: "Restore feature state",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 642,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeFeatureStatesDescription",
      defaultMessage: "Restores the configuration, history, and other data stored in Elasticsearch by a feature such as Elasticsearch security.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 651,
        columnNumber: 13
      }
    }), versionId > 7120099 && isFeatureStatesToggleEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 661,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_system_indices_overwritten_callout.SystemIndicesOverwrittenCallOut, {
      featureStates: restoreSettings === null || restoreSettings === void 0 ? void 0 : restoreSettings.featureStates,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 662,
        columnNumber: 17
      }
    }))),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 638,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: snapshotIncludeFeatureStates ? null : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeFeatureStatesDisabledDescription",
      defaultMessage: "Not available for this snapshot.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 673,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 669,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.restoreFeatureStatesLabel",
      defaultMessage: "Restore feature state from",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 682,
        columnNumber: 15
      }
    }),
    checked: isFeatureStatesToggleEnabled,
    onChange: onFeatureStatesToggleChange,
    disabled: (snapshotIncludeFeatureStates === null || snapshotIncludeFeatureStates === void 0 ? void 0 : snapshotIncludeFeatureStates.length) === 0,
    "data-test-subj": "includeFeatureStatesSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 680,
      columnNumber: 11
    }
  })), isFeatureStatesToggleEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 696,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_feature_states_form_field.FeatureStatesFormField, {
    featuresOptions: snapshotIncludeFeatureStates,
    selectedOptions: selectedFeatureStateOptions,
    onUpdateFormSettings: updateRestoreSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 697,
      columnNumber: 13
    }
  })), (snapshotIncludeFeatureStates === null || snapshotIncludeFeatureStates === void 0 ? void 0 : snapshotIncludeFeatureStates.length) === 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 706,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    size: "s",
    iconType: "question",
    color: "warning",
    "data-test-subj": "noFeatureStatesCallout",
    title: i18n.translate('xpack.snapshotRestore.restoreForm.stepLogistics.noFeatureStates', {
      defaultMessage: 'No feature states are included in this snapshot.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 707,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 725,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 726,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeAliasesTitle",
      defaultMessage: "Restore aliases",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 727,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeAliasesDescription",
      defaultMessage: "Restores index aliases along with their associated indices.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 735,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 723,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 742,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeAliasesLabel",
      defaultMessage: "Restore aliases",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 745,
        columnNumber: 15
      }
    }),
    checked: includeAliases === undefined ? true : includeAliases,
    onChange: e => updateRestoreSettings({
      includeAliases: e.target.checked
    }),
    "data-test-subj": "includeAliasesSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 743,
      columnNumber: 11
    }
  }))));
};
exports.RestoreSnapshotStepLogistics = RestoreSnapshotStepLogistics;