"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavControlPopover = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _spaces_menu = require("./components/spaces_menu");
var _use_spaces = require("./hooks/use_spaces");
var _solution_view_tour = require("./solution_view_tour");
var _space_avatar = require("../space_avatar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/nav_control/nav_control_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const popoutContentId = 'headerSpacesMenuContent';
const NavControlPopoverUI = ({
  spacesManager,
  anchorPosition,
  capabilities,
  navigateToApp,
  navigateToUrl,
  serverBasePath,
  allowSolutionVisibility,
  eventTracker,
  showTour$,
  onFinishTour,
  manageSpacesDocsLink,
  manageSpacesLink
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const [showSpaceSelector, setShowSpaceSelector] = (0, _react.useState)(false);
  const [activeSpace, setActiveSpace] = (0, _react.useState)(null);
  const [showTour, setShowTour] = (0, _react.useState)(false);
  const {
    data,
    isLoading
  } = (0, _use_spaces.useSpaces)(spacesManager);
  (0, _react.useEffect)(() => {
    const activeSpace$ = spacesManager.onActiveSpaceChange$.subscribe({
      next: space => {
        setActiveSpace(space);
      }
    });
    const showTour$Sub = showTour$.subscribe(tour => {
      setShowTour(tour);
    });
    return () => {
      activeSpace$.unsubscribe();
      showTour$Sub.unsubscribe();
    };
  }, [spacesManager, showTour$]);
  const getAlignedLoadingSpinner = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      borderRadius: "m",
      contentAriaLabel: _i18n.i18n.translate('xpack.spaces.navControl.popover.loadingSpacesLabel', {
        defaultMessage: 'Loading spaces navigation'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    });
  }, []);
  const toggleSpaceSelector = (0, _react.useCallback)(() => {
    setShowSpaceSelector(!showSpaceSelector);
    // Invalidate spaces cache when opening the popover to ensure fresh data
    if (!showSpaceSelector) {
      queryClient.invalidateQueries({
        queryKey: _use_spaces.SPACES_QUERY_KEY
      });
    }
  }, [showSpaceSelector, queryClient]);
  const getButton = (0, _react.useCallback)((linkIcon, linkTitle) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
      "aria-controls": popoutContentId,
      "aria-expanded": showSpaceSelector,
      "aria-haspopup": "true",
      "aria-label": _i18n.i18n.translate('xpack.spaces.navControl.popover.spacesNavigationLabel', {
        defaultMessage: 'Spaces navigation'
      }),
      "aria-describedby": "spacesNavDetails",
      "data-test-subj": "spacesNavSelector",
      title: linkTitle,
      onClick: toggleSpaceSelector,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }, linkIcon, /*#__PURE__*/_react.default.createElement("p", {
      id: "spacesNavDetails",
      hidden: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.spaces.navControl.popover.spaceNavigationDetails', {
      defaultMessage: '{space} is the currently selected space. Click this button to open a popover that allows you to select the active space.',
      values: {
        space: linkTitle
      }
    })));
  }, [showSpaceSelector, toggleSpaceSelector]);
  const getActiveSpaceButton = (0, _react.useCallback)(() => {
    if (!activeSpace) {
      return getButton(getAlignedLoadingSpinner(), 'loading spaces navigation');
    }
    return getButton(/*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: getAlignedLoadingSpinner(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      space: activeSpace,
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 9
      }
    })), activeSpace.name);
  }, [activeSpace, getButton, getAlignedLoadingSpinner]);
  const closeSpaceSelector = (0, _react.useCallback)(() => {
    setShowSpaceSelector(false);
  }, []);
  const handleManageSpaceBtnClick = (0, _react.useCallback)(() => {
    // No need to show the tour anymore, the user is taking action
    onFinishTour();
    toggleSpaceSelector();
  }, [onFinishTour, toggleSpaceSelector]);
  const button = getActiveSpaceButton();
  const isTourOpen = Boolean(activeSpace) && showTour && !showSpaceSelector;
  return /*#__PURE__*/_react.default.createElement(_solution_view_tour.SolutionViewTour, {
    solution: activeSpace === null || activeSpace === void 0 ? void 0 : activeSpace.solution,
    isTourOpen: isTourOpen,
    onFinishTour: onFinishTour,
    manageSpacesLink: manageSpacesLink,
    manageSpacesDocsLink: manageSpacesDocsLink,
    navigateToUrl: navigateToUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "spcMenuPopover",
    button: button,
    isOpen: showSpaceSelector,
    closePopover: closeSpaceSelector,
    anchorPosition: anchorPosition,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    ownFocus: true,
    zIndex: Number(euiTheme.levels.navigation) + 1 // it needs to sit above the collapsible nav menu
    ,
    panelProps: {
      'data-test-subj': 'spaceMenuPopoverPanel'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_spaces_menu.SpacesMenu, {
    id: popoutContentId,
    spaces: data || [],
    serverBasePath: serverBasePath,
    toggleSpaceSelector: toggleSpaceSelector,
    capabilities: capabilities,
    navigateToApp: navigateToApp,
    navigateToUrl: navigateToUrl,
    activeSpace: activeSpace,
    allowSolutionVisibility: allowSolutionVisibility,
    eventTracker: eventTracker,
    onClickManageSpaceBtn: handleManageSpaceBtnClick,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  })));
};
const NavControlPopover = exports.NavControlPopover = NavControlPopoverUI;