"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceCard = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _common = require("../../../common");
var _space_avatar = require("../../space_avatar");
var _space_solution_badge = require("../../space_solution_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/spaces/public/space_selector/components/space_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react2.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const SpaceCard = props => {
  const {
    serverBasePath,
    space
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiCard, {
    css: (0, _react.css)`
        width: calc(${euiTheme.size.l} * 10) !important;
        min-height: calc(${euiTheme.size.base} * 12.5); /* 200px */

        .euiCard__content {
          overflow: hidden;
        }
      `,
    "data-test-subj": `space-card-${space.id}`,
    icon: renderSpaceAvatar(space),
    title: space.name,
    description: renderSpaceDescription(space),
    footer: renderSpaceFooter(space),
    href: (0, _common.addSpaceIdToPath)(serverBasePath, space.id, _common.ENTER_SPACE_PATH),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
};
exports.SpaceCard = SpaceCard;
function renderSpaceAvatar(space) {
  // not announcing space name here because the title of the EuiCard that the SpaceAvatar lives in is already
  // announcing it. See https://github.com/elastic/kibana/issues/27748
  return /*#__PURE__*/_react2.default.createElement(_react2.Suspense, {
    fallback: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 25
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(LazySpaceAvatar, {
    space: space,
    size: 'l',
    announceSpaceName: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
}
function renderSpaceDescription(space) {
  let description = space.description || '';
  const needsTruncation = description.length > 120;
  if (needsTruncation) {
    description = description.substr(0, 120) + '…';
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    title: description,
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, description);
}
function renderSpaceFooter(space) {
  if (!space.solution) {
    return undefined;
  }
  return /*#__PURE__*/_react2.default.createElement(_space_solution_badge.SpaceSolutionBadge, {
    solution: space.solution,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 10
    }
  });
}