"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/geo_containment/rule_form/data_view_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataViewSelect = props => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isMounted = (0, _useMountedState.default)();
  return /*#__PURE__*/_react.default.createElement(props.unifiedSearch.ui.IndexPatternSelect, {
    isClearable: false,
    isDisabled: isLoading,
    isInvalid: props.isInvalid,
    isLoading: isLoading,
    indexPatternId: props.dataViewId ? props.dataViewId : '',
    onChange: async dataViewId => {
      if (!dataViewId) {
        return;
      }
      try {
        setIsLoading(true);
        const dataView = await props.data.indexPatterns.get(dataViewId);
        if (isMounted()) {
          props.onChange(dataView);
          setIsLoading(false);
        }
      } catch (error) {
        // ignore indexPatterns.get error,
        // if data view does not exist, select will not update rule params
        if (isMounted()) {
          setIsLoading(false);
        }
      }
    },
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.dataViewSelectPlaceholder', {
      defaultMessage: 'Select data view'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  });
};
exports.DataViewSelect = DataViewSelect;