"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IndexThresholdRuleTypeExpression = exports.DEFAULT_VALUES = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _alertingComparators = require("@kbn/alerting-comparators");
var _visualization = require("./visualization");
var _index_select_popover = require("../components/index_select_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/threshold/expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_VALUES = exports.DEFAULT_VALUES = {
  AGGREGATION_TYPE: 'count',
  TERM_SIZE: 5,
  THRESHOLD_COMPARATOR: _alertingComparators.COMPARATORS.GREATER_THAN,
  TIME_WINDOW_SIZE: 5,
  TIME_WINDOW_UNIT: 'm',
  THRESHOLD: [1000],
  GROUP_BY: 'all'
};
const expressionFieldsWithValidation = ['index', 'timeField', 'aggField', 'termSize', 'termField', 'threshold0', 'threshold1', 'timeWindowSize'];
function isString(value) {
  return typeof value === 'string';
}

// normalize the `index` parameter to be a string array
function indexParamToArray(index) {
  if (!index) return [];
  return isString(index) ? [index] : index;
}
const EMPTY_ARRAY = [];
const IndexThresholdRuleTypeExpression = ({
  ruleParams,
  ruleInterval,
  setRuleParams,
  setRuleProperty,
  errors,
  charts,
  data
}) => {
  const {
    index,
    timeField,
    aggType,
    aggField,
    groupBy,
    termSize,
    termField,
    thresholdComparator,
    threshold,
    timeWindowSize,
    timeWindowUnit,
    filterKuery
  } = ruleParams;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const indexArray = indexParamToArray(index);
  const {
    http
  } = (0, _public.useKibana)().services;
  const [esFields, setEsFields] = (0, _react.useState)(undefined);
  const hasExpressionErrors = !!Object.keys(errors).find(errorKey => expressionFieldsWithValidation.includes(errorKey) &&
  // @ts-expect-error upgrade typescript v5.1.6
  errors[errorKey].length >= 1 && ruleParams[errorKey] !== undefined);
  const cannotShowVisualization = !!Object.keys(errors).find(
  // @ts-expect-error upgrade typescript v5.1.6
  errorKey => expressionFieldsWithValidation.includes(errorKey) && errors[errorKey].length >= 1);
  const expressionErrorMessage = _i18n.i18n.translate('xpack.stackAlerts.threshold.ui.alertParams.fixErrorInExpressionBelowValidationMessage', {
    defaultMessage: 'Expression contains errors.'
  });
  const alertVizualizationChartCss = (0, _react2.css)`
    height: calc(${euiTheme.size.base} * 14);
  `;
  const setDefaultExpressionValues = async () => {
    setRuleProperty('params', {
      ...ruleParams,
      aggType: aggType !== null && aggType !== void 0 ? aggType : DEFAULT_VALUES.AGGREGATION_TYPE,
      termSize: termSize !== null && termSize !== void 0 ? termSize : DEFAULT_VALUES.TERM_SIZE,
      thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : DEFAULT_VALUES.THRESHOLD_COMPARATOR,
      timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : DEFAULT_VALUES.TIME_WINDOW_SIZE,
      timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : DEFAULT_VALUES.TIME_WINDOW_UNIT,
      groupBy: groupBy !== null && groupBy !== void 0 ? groupBy : DEFAULT_VALUES.GROUP_BY,
      threshold: threshold !== null && threshold !== void 0 ? threshold : DEFAULT_VALUES.THRESHOLD
    });
    if (indexArray.length > 0) {
      await refreshEsFields(indexArray);
    } else {
      setEsFields([]);
    }
  };
  const refreshEsFields = async indices => {
    const currentEsFields = await (0, _public2.getFields)(http, indices);
    setEsFields(currentEsFields);
  };
  const handleFilterChange = (0, _react.useCallback)(e => {
    setRuleParams('filterKuery', e.target.value || undefined);
  }, [setRuleParams]);
  (0, _react.useEffect)(() => {
    setDefaultExpressionValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, hasExpressionErrors ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    title: expressionErrorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.threshold.ui.selectIndex",
      defaultMessage: "Select indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_index_select_popover.IndexSelectPopover, {
    index: indexArray,
    "data-test-subj": "indexSelectPopover",
    esFields: esFields !== null && esFields !== void 0 ? esFields : EMPTY_ARRAY,
    timeField: timeField,
    errors: errors,
    onIndexChange: async indices => {
      setRuleParams('index', indices);

      // reset expression fields if indices are deleted
      if (indices.length === 0) {
        setRuleProperty('params', {
          ...ruleParams,
          index: indices,
          aggType: DEFAULT_VALUES.AGGREGATION_TYPE,
          termSize: DEFAULT_VALUES.TERM_SIZE,
          thresholdComparator: DEFAULT_VALUES.THRESHOLD_COMPARATOR,
          timeWindowSize: DEFAULT_VALUES.TIME_WINDOW_SIZE,
          timeWindowUnit: DEFAULT_VALUES.TIME_WINDOW_UNIT,
          groupBy: DEFAULT_VALUES.GROUP_BY,
          threshold: DEFAULT_VALUES.THRESHOLD,
          timeField: ''
        });
      } else {
        await refreshEsFields(indices);
      }
    },
    onTimeFieldChange: updatedTimeField => setRuleParams('timeField', updatedTimeField),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.threshold.ui.conditionPrompt",
      defaultMessage: "Define the condition",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.WhenExpression, {
    display: "fullWidth",
    "data-test-subj": "whenExpression",
    aggType: aggType !== null && aggType !== void 0 ? aggType : DEFAULT_VALUES.AGGREGATION_TYPE,
    onChangeSelectedAggType: selectedAggType => setRuleParams('aggType', selectedAggType),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  })), aggType && _public2.builtInAggregationTypes[aggType].fieldRequired ? /*#__PURE__*/_react.default.createElement(_public2.OfExpression, {
    aggField: aggField,
    "data-test-subj": "aggTypeExpression",
    fields: esFields !== null && esFields !== void 0 ? esFields : EMPTY_ARRAY,
    aggType: aggType,
    errors: errors,
    display: "fullWidth",
    onChangeSelectedAggField: selectedAggField => setRuleParams('aggField', selectedAggField),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_public2.GroupByExpression, {
    groupBy: groupBy || DEFAULT_VALUES.GROUP_BY,
    "data-test-subj": "groupByExpression",
    termField: termField,
    termSize: termSize,
    errors: errors,
    fields: esFields,
    display: "fullWidth",
    onChangeSelectedGroupBy: selectedGroupBy => setRuleParams('groupBy', selectedGroupBy),
    onChangeSelectedTermField: selectedTermField => setRuleParams('termField', selectedTermField),
    onChangeSelectedTermSize: selectedTermSize => setRuleParams('termSize', selectedTermSize),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public2.ThresholdExpression, {
    thresholdComparator: thresholdComparator !== null && thresholdComparator !== void 0 ? thresholdComparator : DEFAULT_VALUES.THRESHOLD_COMPARATOR,
    threshold: threshold,
    "data-test-subj": "thresholdExpression",
    errors: errors,
    display: "fullWidth",
    popupPosition: 'upLeft',
    onChangeSelectedThreshold: selectedThresholds => setRuleParams('threshold', selectedThresholds),
    onChangeSelectedThresholdComparator: selectedThresholdComparator => setRuleParams('thresholdComparator', selectedThresholdComparator),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    "data-test-subj": "forLastExpression",
    popupPosition: 'upLeft',
    timeWindowSize: timeWindowSize !== null && timeWindowSize !== void 0 ? timeWindowSize : DEFAULT_VALUES.TIME_WINDOW_SIZE,
    timeWindowUnit: timeWindowUnit !== null && timeWindowUnit !== void 0 ? timeWindowUnit : DEFAULT_VALUES.TIME_WINDOW_UNIT,
    display: "fullWidth",
    errors: errors,
    onChangeWindowSize: selectedWindowSize => setRuleParams('timeWindowSize', selectedWindowSize),
    onChangeWindowUnit: selectedWindowUnit => setRuleParams('timeWindowUnit', selectedWindowUnit),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.stackAlerts.threshold.ui.filterTitle', {
      defaultMessage: 'Filter'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.threshold.ui.filter.optional",
      defaultMessage: "Optional",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 13
      }
    })),
    helpText: _i18n.i18n.translate('xpack.stackAlerts.threshold.ui.filterKQLHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alerts.'
    }),
    fullWidth: true,
    display: "rowCompressed"
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.filterKuery.length > 0,
    error: errors.filterKuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "filterKuery",
    onChange: handleFilterChange,
    value: filterKuery,
    fullWidth: true
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.filterKuery.length > 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "actAlertVisualization__chart",
    css: alertVizualizationChartCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }, cannotShowVisualization ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "visualizationPlaceholder",
    iconType: "visBarVertical",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackAlerts.threshold.ui.previewAlertVisualizationDescription",
      defaultMessage: "Complete the expression to generate a preview.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 332,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization.ThresholdVisualization, {
    "data-test-subj": "thresholdVisualization",
    ruleParams: ruleParams,
    alertInterval: ruleInterval,
    aggregationTypes: _public2.builtInAggregationTypes,
    comparators: _public2.builtInComparators,
    charts: charts,
    dataFieldsFormats: data.fieldFormats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 13
    }
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.IndexThresholdRuleTypeExpression = IndexThresholdRuleTypeExpression;