"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _severity_filter = require("./severity_filter");
var _status_filter = require("./status_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/cases_webhook/webhook_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CREATE_COMMENT_WARNING_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentWarningTitle', {
  defaultMessage: 'Unable to share case comments'
});
const CREATE_COMMENT_WARNING_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.createCommentWarningDesc', {
  defaultMessage: 'Configure the Create Comment URL and Create Comment Objects fields for the connector to share comments externally.'
});
const WebhookParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  errors,
  index,
  messageVariables
}) => {
  var _incident$title, _incident$description, _incident$id;
  const {
    incident,
    comments
  } = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {
      incident: {},
      comments: []
    };
  }, [actionParams.subActionParams]);
  const {
    createCommentUrl,
    createCommentJson
  } = actionConnector.config;
  const labelOptions = (0, _react.useMemo)(() => incident.tags ? incident.tags.map(label => ({
    label
  })) : [], [incident.tags]);
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    return editAction('subActionParams', {
      incident: {
        ...incident,
        [key]: value
      },
      comments
    }, index);
  }, [comments, editAction, incident, index]);
  const editComment = (0, _react.useCallback)((key, value) => {
    return editAction('subActionParams', {
      incident,
      comments: [{
        commentId: '1',
        comment: value
      }]
    }, index);
  }, [editAction, incident, index]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', 'pushToService', index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        incident: {},
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "title-row",
    fullWidth: true,
    error: errors['subActionParams.incident.title'],
    isInvalid: errors['subActionParams.incident.title'] !== undefined && Number(errors['subActionParams.incident.title'].length) > 0 && incident.title !== undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.titleFieldLabel', {
      defaultMessage: 'Summary'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    }, "Required"),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'title',
    inputTargetValue: (_incident$title = incident.title) !== null && _incident$title !== void 0 ? _incident$title : undefined,
    errors: errors['subActionParams.incident.title'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: (_incident$description = incident.description) !== null && _incident$description !== void 0 ? _incident$description : undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.descriptionTextAreaFieldLabel', {
      defaultMessage: 'Description'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.tagsFieldLabel', {
      defaultMessage: 'Tags'
    }),
    error: errors['subActionParams.incident.tags'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    fullWidth: true,
    selectedOptions: labelOptions,
    onCreateOption: searchValue => {
      const newOptions = [...labelOptions, {
        label: searchValue
      }];
      editSubActionProperty('tags', newOptions.map(newOption => newOption.label));
    },
    onChange: selectedOptions => {
      editSubActionProperty('tags', selectedOptions.map(selectedOption => selectedOption.label));
    },
    onBlur: () => {
      if (!incident.tags) {
        editSubActionProperty('tags', []);
      }
    },
    isClearable: true,
    "data-test-subj": "tagsComboBox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.statusFieldLabel', {
      defaultMessage: 'Status'
    }),
    error: errors['subActionParams.incident.status'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_status_filter.StatusFilter, {
    selectedStatus: incident.status,
    onStatusChanged: status => editSubActionProperty('status', status),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.severityFieldLabel', {
      defaultMessage: 'Severity'
    }),
    error: errors['subActionParams.incident.severity'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_severity_filter.SeverityFilter, {
    selectedSeverity: incident.severity,
    onSeverityChange: severity => editSubActionProperty('severity', severity),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "id-row",
    fullWidth: true,
    error: errors['subActionParams.incident.id'],
    isInvalid: errors['subActionParams.incident.id'] !== undefined && Number(errors['subActionParams.incident.id'].length) > 0 && incident.id !== undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.idFieldLabel', {
      defaultMessage: 'Case ID'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'id',
    inputTargetValue: (_incident$id = incident.id) !== null && _incident$id !== void 0 ? _incident$id : undefined,
    errors: errors['subActionParams.incident.id'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    isDisabled: !createCommentUrl || !createCommentJson,
    editAction: editComment,
    messageVariables: messageVariables,
    paramsProperty: 'comments',
    inputTargetValue: comments && comments.length > 0 ? comments[0].comment : undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.casesWebhook.commentsTextAreaFieldLabel', {
      defaultMessage: 'Additional comments'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }), (!createCommentUrl || !createCommentJson) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: CREATE_COMMENT_WARNING_TITLE,
    color: "warning",
    iconType: "question",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, CREATE_COMMENT_WARNING_DESC)))));
};

// eslint-disable-next-line import/no-default-export
exports.default = WebhookParamsFields;
module.exports = exports.default;