"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var translations = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/es_index/es_index_connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  indexPatternField,
  emptyField
} = _helpers.fieldValidators;
const getIndexConfig = docLinks => ({
  label: translations.INDEX_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.index.howToBroadenSearchQueryDescription",
    defaultMessage: "Use * to broaden your query.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.alerting.indexAction,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.index.configureIndexHelpLabel",
    defaultMessage: "Configuring index connector.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }))),
  validations: [{
    validator: emptyField(translations.INDEX_IS_NOT_VALID)
  }, {
    validator: indexPatternField(_i18n.i18n),
    type: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM
  }]
});
const IndexActionConnectorFields = ({
  readOnly
}) => {
  const {
    http,
    docLinks
  } = (0, _public.useKibana)().services;
  const {
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    __internal__
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.executionTimeField', 'config.index', '__internal__.hasTimeFieldCheckbox']
  });
  const {
    index = null
  } = config !== null && config !== void 0 ? config : {};
  const [indexOptions, setIndexOptions] = (0, _react.useState)([]);
  const [timeFieldOptions, setTimeFieldOptions] = (0, _react.useState)([]);
  const [areIndiciesLoading, setAreIndicesLoading] = (0, _react.useState)(false);
  const hasTimeFieldCheckboxDefaultValue = !!getFieldDefaultValue('config.executionTimeField');
  const showTimeFieldCheckbox = index != null && timeFieldOptions.length > 0;
  const showTimeFieldSelect = __internal__ != null ? __internal__.hasTimeFieldCheckbox : false;
  const setTimeFields = fields => {
    if (fields.length > 0) {
      setTimeFieldOptions([_public.firstFieldOption, ...fields]);
    } else {
      setTimeFieldOptions([]);
    }
  };
  const loadIndexOptions = (0, _lodash.debounce)(async search => {
    setAreIndicesLoading(true);
    setIndexOptions(await (0, _public.getIndexOptions)(http, search));
    setAreIndicesLoading(false);
  }, 250);
  (0, _react.useEffect)(() => {
    const indexPatternsFunction = async () => {
      if (index) {
        const currentEsFields = await (0, _public.getFields)(http, [index]);
        if (Array.isArray(currentEsFields)) {
          setTimeFields((0, _public.getTimeFieldOptions)(currentEsFields));
        }
      }
    };
    indexPatternsFunction();
  }, [http, index]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Write to index",
    id: "xpack.stackConnectors.components.index.connectorSectionTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.refresh",
    component: _components.HiddenField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.index",
    config: getIndexConfig(docLinks),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onComboChange = async options => {
      field.setValue(options.length > 0 ? options[0].value : '');
      const indices = options.map(s => s.value);

      // reset time field and expression fields if indices are deleted
      if (indices.length === 0) {
        setTimeFields([]);
        return;
      }
      const currentEsFields = await (0, _public.getFields)(http, indices);
      setTimeFields((0, _public.getTimeFieldOptions)(currentEsFields));
    };
    const onSearchComboChange = value => {
      if (value !== undefined) {
        field.clearErrors(_hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM);
      }
      loadIndexOptions(value);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "indexConnectorSelectSearchBox",
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.index.indicesToQueryLabel",
        defaultMessage: "Index",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 17
        }
      }),
      isInvalid: isInvalid,
      error: errorMessage,
      helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.index.howToBroadenSearchQueryDescription",
        defaultMessage: "Use * to broaden your query.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.alerting.indexAction,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.index.configureIndexHelpLabel",
        defaultMessage: "Configuring index connector.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 21
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      async: true,
      isLoading: areIndiciesLoading,
      isInvalid: isInvalid,
      noSuggestions: !indexOptions.length,
      options: indexOptions,
      "data-test-subj": "connectorIndexesComboBox",
      "data-testid": "connectorIndexesComboBox",
      selectedOptions: index ? [{
        value: index,
        label: index
      }] : [],
      isDisabled: readOnly,
      onChange: onComboChange,
      onSearchChange: onSearchComboChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 15
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 7
    }
  }), showTimeFieldCheckbox ? /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.hasTimeFieldCheckbox",
    component: _components.ToggleField,
    config: {
      defaultValue: hasTimeFieldCheckboxDefaultValue
    },
    componentProps: {
      euiFieldProps: {
        label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.stackConnectors.components.index.defineTimeFieldLabel",
          defaultMessage: "Define time field for each document",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 224,
            columnNumber: 19
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          position: "right",
          type: "question",
          content: translations.SHOW_TIME_FIELD_TOGGLE_TOOLTIP,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 228,
            columnNumber: 19
          }
        })),
        disabled: readOnly,
        'data-test-subj': 'hasTimeFieldCheckbox'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }) : null, showTimeFieldSelect ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.executionTimeField",
    component: _components.SelectField,
    config: {
      label: translations.EXECUTION_TIME_LABEL
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'executionTimeFieldSelect',
        options: timeFieldOptions,
        fullWidth: true,
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  })) : null);
};

// eslint-disable-next-line import/no-default-export
exports.default = IndexActionConnectorFields;
module.exports = exports.default;