"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IndexParamsFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/es_index/es_index_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexParamsFields = ({
  actionParams,
  index,
  editAction,
  messageVariables,
  errors,
  actionConnector
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  const {
    documents,
    indexOverride
  } = actionParams;
  const defaultAlertHistoryIndexSuffix = _public.AlertHistoryDefaultIndexName.replace(_public.ALERT_HISTORY_PREFIX, '');
  const [isActionConnectorChanged, setIsActionConnectorChanged] = (0, _react.useState)(false);
  const getDocumentToIndex = docs => {
    // 'documents' param is stored as an array of objects but the JSON editor expects a single
    // stringified object

    // check that param is a non-empty array
    return docs && docs.length > 0 ?
    // if the array entry is a string, we can pass it directly to the JSON editor
    typeof docs[0] === 'string' ? docs[0] :
    // otherwise check that the array entry is non-empty as sometimes we
    // use an empty object to trigger validation but we don't want to auto-populate with an empty object
    !(0, _lodash.isEmpty)(docs[0]) ?
    // if non-empty object, stringify it into format that JSON editor expects
    JSON.stringify(docs[0], null, 2) : null : '';
  };
  const [documentToIndex, setDocumentToIndex] = (0, _react.useState)(getDocumentToIndex(documents));
  const [alertHistoryIndexSuffix, setAlertHistoryIndexSuffix] = (0, _react.useState)(indexOverride ? indexOverride.replace(_public.ALERT_HISTORY_PREFIX, '') : defaultAlertHistoryIndexSuffix);
  const [usePreconfiguredSchema, setUsePreconfiguredSchema] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setDocumentToIndex(getDocumentToIndex(documents));
  }, [documents]);
  (0, _react.useEffect)(() => {
    if ((actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) === _public.AlertHistoryEsIndexConnectorId) {
      setUsePreconfiguredSchema(true);
      editAction('documents', [JSON.stringify(_public.AlertHistoryDocumentTemplate)], index);
      setDocumentToIndex(JSON.stringify(_public.AlertHistoryDocumentTemplate));
    } else if (isActionConnectorChanged) {
      setUsePreconfiguredSchema(false);
      editAction('documents', undefined, index);
      setDocumentToIndex(undefined);
    }
    setIsActionConnectorChanged(true);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id]);
  const onDocumentsChange = updatedDocuments => {
    try {
      if (updatedDocuments != null) {
        const documentsJSON = JSON.parse(updatedDocuments);
        editAction('documents', [documentsJSON], index);
      } else {
        editAction('documents', updatedDocuments, index);
      }
      setDocumentToIndex(updatedDocuments);
    } catch (e) {
      // set document as empty to turn on the validation for non empty valid JSON object
      editAction('documents', [{}], index);
      setDocumentToIndex(undefined);
    }
  };
  const documentsFieldLabel = _i18n.i18n.translate('xpack.stackConnectors.components.index.documentsFieldLabel', {
    defaultMessage: 'Document to index'
  });
  const resetDefaultIndex = indexOverride && indexOverride !== _public.AlertHistoryDefaultIndexName ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "resetDefaultIndex",
    onClick: () => {
      editAction('indexOverride', _public.AlertHistoryDefaultIndexName, index);
      setAlertHistoryIndexSuffix(defaultAlertHistoryIndexSuffix);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "refresh",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.index.resetDefaultIndexLabel",
    defaultMessage: "Reset default index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const preconfiguredDocumentSchema = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.indexOverride,
    isInvalid: errors.indexOverride !== undefined && Number(errors.indexOverride.length) > 0,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.index.preconfiguredIndex', {
      defaultMessage: 'Elasticsearch index'
    }),
    labelAppend: resetDefaultIndex,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackConnectors.components.index.preconfiguredIndexHelpText",
      defaultMessage: "Documents are indexed into the {alertHistoryIndex} index. ",
      values: {
        alertHistoryIndex: `${_public.ALERT_HISTORY_PREFIX}${alertHistoryIndexSuffix}`
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.alerting.preconfiguredAlertHistoryConnector,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackConnectors.components.index.preconfiguredIndexDocLink",
      defaultMessage: "View docs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: errors.indexOverride !== undefined && Number(errors.indexOverride.length) > 0,
    fullWidth: true,
    "data-test-subj": "preconfiguredIndexToUse",
    prepend: _public.ALERT_HISTORY_PREFIX,
    value: alertHistoryIndexSuffix,
    onChange: e => {
      editAction('indexOverride', `${_public.ALERT_HISTORY_PREFIX}${e.target.value}`, index);
      setAlertHistoryIndexSuffix(e.target.value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: documentsFieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    fontSize: "s",
    paddingSize: "s",
    "data-test-subj": "preconfiguredDocumentToIndex",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, JSON.stringify(_public.AlertHistoryDocumentTemplate, null, 2))));
  const jsonDocumentEditor = /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'documents',
    dataTestSubj: "documentToIndex",
    inputTargetValue: documentToIndex,
    label: documentsFieldLabel,
    ariaLabel: _i18n.i18n.translate('xpack.stackConnectors.components.index.jsonDocAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    errors: errors.documents,
    onDocumentsChange: onDocumentsChange,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.alerting.indexAction,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackConnectors.components.index.indexDocumentHelpLabel",
      defaultMessage: "Index document example.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 11
      }
    })),
    onBlur: () => {
      if (!documentToIndex) {
        // set document as empty to turn on the validation for non empty valid JSON object
        onDocumentsChange(null);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  });
  return usePreconfiguredSchema ? preconfiguredDocumentSchema : jsonDocumentEditor;
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.IndexParamsFields = IndexParamsFields;