"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/inference/connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const solutionMap = {
  observability: 'oblt',
  search: 'es'
};
const InferenceAPIConnectorFields = ({
  isEdit
}) => {
  var _cloud$serverless2;
  const {
    cloud,
    http,
    notifications: {
      toasts
    },
    spaces,
    isServerless: isServerlessKibanaContext
  } = (0, _public.useKibana)().services;
  const isMounted = (0, _useMountedState.default)();
  const {
    isServerless: isServerlessConnectorContext
  } = (0, _public.useConnectorContext)();
  const isServerless = isServerlessKibanaContext !== null && isServerlessKibanaContext !== void 0 ? isServerlessKibanaContext : isServerlessConnectorContext;
  const [activeSpaceSolution, setActiveSpaceSolution] = (0, _react.useState)();
  const currentSolution = (0, _react.useMemo)(() => {
    let solution;
    if (isServerless) {
      var _cloud$serverless;
      const projectType = cloud === null || cloud === void 0 ? void 0 : (_cloud$serverless = cloud.serverless) === null || _cloud$serverless === void 0 ? void 0 : _cloud$serverless.projectType;
      solution = projectType && solutionMap[projectType] ? solutionMap[projectType] : projectType;
    } else {
      solution = activeSpaceSolution;
    }
    return solution;
  }, [isServerless, activeSpaceSolution, cloud === null || cloud === void 0 ? void 0 : (_cloud$serverless2 = cloud.serverless) === null || _cloud$serverless2 === void 0 ? void 0 : _cloud$serverless2.projectType]);
  (0, _react.useEffect)(() => {
    async function getSolution() {
      if (!isMounted() || !(spaces !== null && spaces !== void 0 && spaces.getActiveSpace)) {
        return;
      }
      const space = await (spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace());
      setActiveSpaceSolution(space === null || space === void 0 ? void 0 : space.solution);
    }
    getSolution();
  }, [spaces, spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace, isMounted]);
  return /*#__PURE__*/_react.default.createElement(_inferenceEndpointUiCommon.InferenceServiceFormFields, {
    config: {
      isEdit,
      enforceAdaptiveAllocations: isServerless,
      currentSolution,
      allowContextWindowLength: true
    },
    http: http,
    toasts: toasts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = InferenceAPIConnectorFields;
module.exports = exports.default;