"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _servicenow_config = require("../../../../common/servicenow_config");
var _deprecated_callout = require("./deprecated_callout");
var _use_get_app_info = require("./use_get_app_info");
var _application_required_callout = require("./application_required_callout");
var _helpers = require("./helpers");
var _installation_callout = require("./installation_callout");
var _update_connector = require("./update_connector");
var _credentials = require("./credentials");
var i18n = _interopRequireWildcard(require("./translations"));
var _error_callout = require("./error_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/lib/servicenow/servicenow_connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line import/no-default-export
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ServiceNowConnectorFields = ({
  readOnly,
  registerPreSubmitValidator,
  isEdit
}) => {
  var _snExternalServiceCon2, _snExternalServiceCon3;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const {
    updateFieldValues
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    id,
    isDeprecated,
    actionTypeId,
    name,
    config,
    secrets
  }] = (0, _hook_form_lib.useFormData)();
  const requiresNewApplication = isDeprecated != null ? !isDeprecated : true;
  const {
    isOAuth = false
  } = config !== null && config !== void 0 ? config : {};
  const action = (0, _react.useMemo)(() => ({
    name,
    actionTypeId,
    config,
    secrets
  }), [name, actionTypeId, config, secrets]);
  const [showUpdateConnector, setShowUpdateConnector] = (0, _react.useState)(false);
  const [updateErrorMessage, setUpdateErrorMessage] = (0, _react.useState)(null);
  const {
    fetchAppInfo,
    isLoading
  } = (0, _use_get_app_info.useGetAppInfo)({
    actionTypeId,
    http
  });
  const getApplicationInfo = (0, _react.useCallback)(async connector => {
    try {
      const res = await fetchAppInfo(connector);
      if ((0, _helpers.isRESTApiError)(res)) {
        var _res$error$message, _res$error;
        throw new Error((_res$error$message = (_res$error = res.error) === null || _res$error === void 0 ? void 0 : _res$error.message) !== null && _res$error$message !== void 0 ? _res$error$message : i18n.UNKNOWN);
      }
      return res;
    } catch (e) {
      throw e;
    }
  }, [fetchAppInfo]);
  const preSubmitValidator = (0, _react.useCallback)(async () => {
    if (requiresNewApplication) {
      try {
        await getApplicationInfo(action);
      } catch (error) {
        if ((0, _helpers.isCORSError)(error)) {
          var _snExternalServiceCon;
          return {
            message: /*#__PURE__*/_react.default.createElement(_application_required_callout.ApplicationRequiredCallout, {
              appId: actionTypeId != null ? (_snExternalServiceCon = _servicenow_config.snExternalServiceConfig[actionTypeId]) === null || _snExternalServiceCon === void 0 ? void 0 : _snExternalServiceCon.appId : '',
              message: error.message,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 93,
                columnNumber: 15
              }
            })
          };
        }
        return {
          message: /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
            message: error.message,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 102,
              columnNumber: 20
            }
          })
        };
      }
    }
  }, [action, actionTypeId, getApplicationInfo, requiresNewApplication]);
  (0, _react.useEffect)(() => registerPreSubmitValidator(preSubmitValidator), [preSubmitValidator, registerPreSubmitValidator]);
  const onMigrateClick = (0, _react.useCallback)(() => setShowUpdateConnector(true), []);
  const onModalCancel = (0, _react.useCallback)(() => setShowUpdateConnector(false), []);
  const onUpdateConnectorConfirm = (0, _react.useCallback)(async updatedConnector => {
    const connectorToUpdate = {
      name: name !== null && name !== void 0 ? name : '',
      config: {
        ...updatedConnector.config,
        usesTableApi: false
      },
      secrets: {
        ...updatedConnector.secrets
      },
      id: id !== null && id !== void 0 ? id : ''
    };
    try {
      await getApplicationInfo({
        ...connectorToUpdate,
        isDeprecated,
        isPreconfigured: false,
        isSystemAction: false,
        actionTypeId
      });
      const res = await (0, _public.updateActionConnector)({
        http,
        connector: connectorToUpdate,
        id: id !== null && id !== void 0 ? id : ''
      });
      toasts.addSuccess({
        title: i18n.UPDATE_SUCCESS_TOAST_TITLE(name !== null && name !== void 0 ? name : ''),
        text: i18n.UPDATE_SUCCESS_TOAST_TEXT
      });
      setShowUpdateConnector(false);
      updateFieldValues({
        isDeprecated: res.isDeprecated,
        config: updatedConnector.config
      });
    } catch (err) {
      setUpdateErrorMessage(err.message);
    }
  }, [name, id, getApplicationInfo, isDeprecated, actionTypeId, http, updateFieldValues, toasts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionTypeId && showUpdateConnector && /*#__PURE__*/_react.default.createElement(_update_connector.UpdateConnector, {
    actionTypeId: actionTypeId,
    readOnly: readOnly,
    isLoading: isLoading,
    updateErrorMessage: updateErrorMessage,
    onConfirm: onUpdateConnectorConfirm,
    onCancel: onModalCancel,
    isOAuth: isOAuth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }), requiresNewApplication && /*#__PURE__*/_react.default.createElement(_installation_callout.InstallationCallout, {
    appId: (_snExternalServiceCon2 = (_snExternalServiceCon3 = _servicenow_config.snExternalServiceConfig[action.actionTypeId]) === null || _snExternalServiceCon3 === void 0 ? void 0 : _snExternalServiceCon3.appId) !== null && _snExternalServiceCon2 !== void 0 ? _snExternalServiceCon2 : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }), !requiresNewApplication && /*#__PURE__*/_react.default.createElement(SpacedDeprecatedCallout, {
    onMigrate: onMigrateClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 35
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.usesTableApi",
    component: _components.HiddenField,
    config: {
      defaultValue: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_credentials.Credentials, {
    readOnly: readOnly,
    isLoading: isLoading,
    isOAuth: isOAuth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }));
};
exports.default = ServiceNowConnectorFields;
const SpacedDeprecatedCallout = ({
  onMigrate
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 188,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, {
  onMigrate: onMigrate,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 189,
    columnNumber: 5
  }
}));
module.exports = exports.default;