"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _servicenow_config = require("../../../../common/servicenow_config");
var _credentials_api_url = require("./credentials_api_url");
var _auth_types = require("./auth_types");
var _sn_store_button = require("./sn_store_button");
var _application_required_callout = require("./application_required_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/lib/servicenow/update_connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const title = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateFormTitle', {
  defaultMessage: 'Update ServiceNow connector'
});
const step1InstallTitle = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateFormInstallTitle', {
  defaultMessage: 'Install the Elastic ServiceNow app'
});
const step2InstanceUrlTitle = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateFormUrlTitle', {
  defaultMessage: 'Enter your ServiceNow instance URL'
});
const step3CredentialsTitle = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.updateFormCredentialsTitle', {
  defaultMessage: 'Provide authentication credentials'
});
const cancelButtonText = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.cancelButtonText', {
  defaultMessage: 'Cancel'
});
const confirmButtonText = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.confirmButtonText', {
  defaultMessage: 'Update'
});
const warningMessage = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.warningMessage', {
  defaultMessage: 'This updates all instances of this connector and cannot be reversed.'
});
const PATH_PREFIX = 'updatedConnector.';
const UpdateConnectorComponent = ({
  actionTypeId,
  isOAuth,
  isLoading,
  readOnly,
  onCancel,
  onConfirm,
  updateErrorMessage
}) => {
  var _snExternalServiceCon, _snExternalServiceCon2;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    form
  } = (0, _hook_form_lib.useForm)();
  const {
    submit,
    isValid
  } = form;
  const onSubmit = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid: isSubmitValid
    } = await submit();
    if (!isSubmitValid) {
      return;
    }
    const {
      updatedConnector
    } = data;
    onConfirm(updatedConnector);
  }, [onConfirm, submit]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": modalTitleId,
    ownFocus: true,
    onClose: onCancel,
    "data-test-subj": "updateConnectorForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      color: "danger",
      iconType: "warning",
      "data-test-subj": "snUpdateInstallationCallout",
      title: warningMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: step1InstallTitle,
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.stackConnectors.components.serviceNow.appRunning",
        defaultMessage: "The Elastic App from the ServiceNow app store must be installed prior to running the update. {visitLink} to install the app",
        values: {
          visitLink: /*#__PURE__*/_react.default.createElement(_sn_store_button.SNStoreLink, {
            appId: (_snExternalServiceCon = _servicenow_config.snExternalServiceConfig[actionTypeId].appId) !== null && _snExternalServiceCon !== void 0 ? _snExternalServiceCon : '',
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 156,
              columnNumber: 27
            }
          })
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 21
        }
      })
    }, {
      title: step2InstanceUrlTitle,
      children: /*#__PURE__*/_react.default.createElement(_credentials_api_url.CredentialsApiUrl, {
        readOnly: readOnly,
        isLoading: isLoading,
        pathPrefix: PATH_PREFIX,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 21
        }
      })
    }, {
      title: step3CredentialsTitle,
      children: isOAuth ? /*#__PURE__*/_react.default.createElement(_auth_types.OAuth, {
        readOnly: readOnly,
        isLoading: isLoading,
        pathPrefix: PATH_PREFIX,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 21
        }
      }) : /*#__PURE__*/_react.default.createElement(_auth_types.CredentialsAuth, {
        readOnly: readOnly,
        isLoading: isLoading,
        pathPrefix: PATH_PREFIX,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 21
        }
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }, updateErrorMessage != null ? /*#__PURE__*/_react.default.createElement(_application_required_callout.ApplicationRequiredCallout, {
    message: updateErrorMessage,
    appId: (_snExternalServiceCon2 = _servicenow_config.snExternalServiceConfig[actionTypeId].appId) !== null && _snExternalServiceCon2 !== void 0 ? _snExternalServiceCon2 : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 17
    }
  }) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "snUpdateInstallationCancel",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }, cancelButtonText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "snUpdateInstallationSubmit",
    onClick: onSubmit,
    color: "danger",
    fill: true,
    disabled: !isValid,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, confirmButtonText))))));
};
const UpdateConnector = exports.UpdateConnector = /*#__PURE__*/(0, _react.memo)(UpdateConnectorComponent);