"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _constants2 = require("../../../common/thehive/constants");
var _params_alert = require("./params_alert");
var _params_case = require("./params_case");
var translations = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/thehive/params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TheHiveParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  errors,
  messageVariables,
  executionMode
}) => {
  var _actionParams$subActi, _actionConnector$id;
  const [eventAction, setEventAction] = (0, _react.useState)((_actionParams$subActi = actionParams.subAction) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : _constants2.SUB_ACTION.PUSH_TO_SERVICE);
  const actionConnectorRef = (0, _react.useRef)((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '');
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  (0, _react.useEffect)(() => {
    if (actionConnector != null && actionConnectorRef.current !== actionConnector.id) {
      actionConnectorRef.current = actionConnector.id;
      editAction('subActionParams', {
        incident: {
          tlp: 2,
          severity: 2,
          tags: []
        },
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', _constants2.SUB_ACTION.PUSH_TO_SERVICE, index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        incident: {
          tlp: 2,
          severity: 2,
          tags: []
        },
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  (0, _react.useEffect)(() => {
    editAction('subAction', eventAction, index);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [eventAction]);
  const setEventActionType = eventActionType => {
    const subActionParams = eventActionType === _constants2.SUB_ACTION.CREATE_ALERT ? {
      tlp: 2,
      severity: _constants2.TheHiveSeverity.MEDIUM,
      tags: [],
      sourceRef: isTest ? undefined : '{{alert.uuid}}'
    } : {
      incident: {
        tlp: 2,
        severity: 2,
        tags: []
      },
      comments: []
    };
    setEventAction(eventActionType);
    editAction('subActionParams', subActionParams, index);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: translations.EVENT_ACTION_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "eventActionSelect",
    options: _constants.eventActionOptions,
    value: eventAction,
    onChange: e => setEventActionType(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })), eventAction === _constants2.SUB_ACTION.PUSH_TO_SERVICE ? /*#__PURE__*/_react.default.createElement(_params_case.TheHiveParamsCaseFields, {
    actionParams: actionParams,
    editAction: editAction,
    index: index,
    errors: errors,
    messageVariables: messageVariables,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_params_alert.TheHiveParamsAlertFields, {
    actionParams: actionParams,
    editAction: editAction,
    index: index,
    errors: errors,
    messageVariables: messageVariables,
    executionMode: executionMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = TheHiveParamsFields;
module.exports = exports.default;