"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TheHiveParamsCaseFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var translations = _interopRequireWildcard(require("./translations"));
var _optional_field_label = require("../../common/optional_field_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/thehive/params_case.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TheHiveParamsCaseFields = ({
  actionParams,
  editAction,
  index,
  errors,
  messageVariables
}) => {
  var _incident$severity, _incident$tlp, _incident$tags$map, _incident$tags, _incident$title, _incident$description;
  const {
    incident,
    comments
  } = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = actionParams.subActionParams) !== null && _ref !== void 0 ? _ref : {
      incident: {
        tlp: 2,
        severity: 2,
        tags: []
      },
      comments: []
    };
  }, [actionParams.subActionParams]);
  const [severity, setSeverity] = (0, _react.useState)((_incident$severity = incident.severity) !== null && _incident$severity !== void 0 ? _incident$severity : _constants.severityOptions[1].value);
  const [tlp, setTlp] = (0, _react.useState)((_incident$tlp = incident.tlp) !== null && _incident$tlp !== void 0 ? _incident$tlp : _constants.tlpOptions[2].value);
  const [selectedOptions, setSelected] = (0, _react.useState)((_incident$tags$map = (_incident$tags = incident.tags) === null || _incident$tags === void 0 ? void 0 : _incident$tags.map(tag => ({
    label: tag
  }))) !== null && _incident$tags$map !== void 0 ? _incident$tags$map : []);
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    const newProps = key !== 'comments' ? {
      incident: {
        ...incident,
        [key]: value
      },
      comments
    } : {
      incident,
      [key]: value
    };
    editAction('subActionParams', newProps, index);
  }, [comments, editAction, incident, index]);
  const editComment = (0, _react.useCallback)((key, value) => {
    editSubActionProperty(key, [{
      commentId: '1',
      comment: value
    }]);
  }, [editSubActionProperty]);
  const onCreateOption = searchValue => {
    var _incident$tags2;
    setSelected([...selectedOptions, {
      label: searchValue
    }]);
    editSubActionProperty('tags', [...((_incident$tags2 = incident.tags) !== null && _incident$tags2 !== void 0 ? _incident$tags2 : []), searchValue]);
  };
  const onChange = selectedOptionList => {
    setSelected(selectedOptionList);
    editSubActionProperty('tags', selectedOptionList.map(option => option.label));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'title',
    inputTargetValue: (_incident$title = incident.title) !== null && _incident$title !== void 0 ? _incident$title : undefined,
    wrapField: true,
    formRowProps: {
      label: translations.TITLE_LABEL,
      fullWidth: true,
      helpText: '',
      isInvalid: errors['pushToServiceParam.incident.title'] !== undefined && Number(errors['pushToServiceParam.incident.title'].length) > 0 && incident.title !== undefined,
      error: errors['pushToServiceParam.incident.title']
    },
    errors: errors['pushToServiceParam.incident.title'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    label: translations.DESCRIPTION_LABEL,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: (_incident$description = incident.description) !== null && _incident$description !== void 0 ? _incident$description : undefined,
    errors: errors['pushToServiceParam.incident.description'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.severity,
    label: translations.SEVERITY_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "severitySelectInput",
    value: severity,
    options: _constants.severityOptions,
    onChange: e => {
      editSubActionProperty('severity', parseInt(e.target.value, 10));
      setSeverity(parseInt(e.target.value, 10));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.tlp,
    label: translations.TLP_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    value: tlp,
    "data-test-subj": "tlpSelectInput",
    options: _constants.tlpOptions,
    onChange: e => {
      editSubActionProperty('tlp', parseInt(e.target.value, 10));
      setTlp(parseInt(e.target.value, 10));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: translations.TAGS_LABEL,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "tagsInput",
    fullWidth: true,
    selectedOptions: selectedOptions,
    onCreateOption: onCreateOption,
    onChange: onChange,
    noSuggestions: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editComment,
    messageVariables: messageVariables,
    paramsProperty: 'comments',
    label: translations.COMMENTS_LABEL,
    inputTargetValue: comments && comments.length > 0 ? comments[0].comment : undefined,
    isOptionalField: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }));
};
exports.TheHiveParamsCaseFields = TheHiveParamsCaseFields;