"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("../../../common/tines/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/tines/tines_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createOption = item => ({
  key: item.id.toString(),
  value: item,
  label: item.name
});
const renderStory = ({
  label,
  value
}, searchValue, contentClassName) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: contentClassName,
  direction: "row",
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
  search: searchValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 7
  }
}, label)), (value === null || value === void 0 ? void 0 : value.published) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "hollow",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 9
  }
}, i18n.STORY_PUBLISHED_BADGE_TEXT)));
const TinesParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  executionMode,
  errors
}) => {
  var _selectedStoryOption$, _selectedStoryOption$2, _errors$story, _errors$story2, _errors$webhook, _errors$webhook2, _errors$webhookUrl, _errors$webhookUrl2;
  const {
    toasts
  } = (0, _public.useKibana)().services.notifications;
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    body,
    webhook,
    webhookUrl
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const [connectorId, setConnectorId] = (0, _react.useState)(actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id);
  const [selectedStoryOption, setSelectedStoryOption] = (0, _react.useState)();
  const [selectedWebhookOption, setSelectedWebhookOption] = (0, _react.useState)();
  const [bodyOption, setBodyOption] = (0, _react.useState)('');
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', isTest ? _constants.SUB_ACTION.TEST : _constants.SUB_ACTION.RUN, index);
    }
  }, [editAction, index, isTest, subAction]);
  if (connectorId !== (actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id)) {
    // Story (and webhook) reset needed before requesting with a different connectorId
    setSelectedStoryOption(null);
    setConnectorId(actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id);
  }
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  const {
    response: {
      stories,
      incompleteResponse: incompleteStories
    } = {},
    isLoading: isLoadingStories,
    error: storiesError
  } = (0, _public.useSubAction)({
    connectorId,
    subAction: 'stories'
  });
  const {
    response: {
      webhooks,
      incompleteResponse: incompleteWebhooks
    } = {},
    isLoading: isLoadingWebhooks,
    error: webhooksError
  } = (0, _public.useSubAction)({
    connectorId,
    subAction: 'webhooks',
    ...(selectedStoryOption !== null && selectedStoryOption !== void 0 && (_selectedStoryOption$ = selectedStoryOption.value) !== null && _selectedStoryOption$ !== void 0 && _selectedStoryOption$.id ? {
      subActionParams: {
        storyId: selectedStoryOption === null || selectedStoryOption === void 0 ? void 0 : (_selectedStoryOption$2 = selectedStoryOption.value) === null || _selectedStoryOption$2 === void 0 ? void 0 : _selectedStoryOption$2.id
      }
    } : {
      disabled: true
    })
  });
  const storiesOptions = (0, _react.useMemo)(() => {
    var _stories$map;
    return (_stories$map = stories === null || stories === void 0 ? void 0 : stories.map(createOption)) !== null && _stories$map !== void 0 ? _stories$map : [];
  }, [stories]);
  const webhooksOptions = (0, _react.useMemo)(() => {
    var _webhooks$map;
    return (_webhooks$map = webhooks === null || webhooks === void 0 ? void 0 : webhooks.map(createOption)) !== null && _webhooks$map !== void 0 ? _webhooks$map : [];
  }, [webhooks]);
  (0, _react.useEffect)(() => {
    if (storiesError) {
      toasts.addDanger({
        title: i18n.STORIES_ERROR,
        text: storiesError.message
      });
    }
    if (webhooksError) {
      toasts.addDanger({
        title: i18n.WEBHOOKS_ERROR,
        text: webhooksError.message
      });
    }
  }, [toasts, storiesError, webhooksError]);
  const showFallbackFrom = (0, _react.useMemo)(() => {
    if (storiesError || webhooksError) {
      return 'error';
    }
    if (incompleteStories && !selectedStoryOption) {
      return 'Story';
    }
    if (incompleteWebhooks && !selectedWebhookOption) {
      return 'Webhook';
    }
    if (webhookUrl) {
      return 'any'; // no incompleteResponse but webhookUrl is stored in the connector
    }
    return null;
  }, [webhookUrl, storiesError, incompleteStories, webhooksError, incompleteWebhooks, selectedStoryOption, selectedWebhookOption]);
  (0, _react.useEffect)(() => {
    var _selectedStoryOption$3;
    if (selectedStoryOption === undefined && webhook !== null && webhook !== void 0 && webhook.storyId && stories) {
      // Set the initial selected story option from saved storyId when stories are loaded
      const selectedStory = stories.find(({
        id
      }) => id === webhook.storyId);
      if (selectedStory) {
        setSelectedStoryOption(createOption(selectedStory));
      } else {
        toasts.addWarning({
          title: i18n.STORY_NOT_FOUND_WARNING
        });
        editSubActionParams({
          webhook: undefined
        });
      }
    }
    if (selectedStoryOption !== undefined && (selectedStoryOption === null || selectedStoryOption === void 0 ? void 0 : (_selectedStoryOption$3 = selectedStoryOption.value) === null || _selectedStoryOption$3 === void 0 ? void 0 : _selectedStoryOption$3.id) !== (webhook === null || webhook === void 0 ? void 0 : webhook.storyId)) {
      var _selectedStoryOption$4;
      // Selected story changed, update storyId param and remove the rest webhook values
      editSubActionParams({
        webhook: {
          storyId: selectedStoryOption === null || selectedStoryOption === void 0 ? void 0 : (_selectedStoryOption$4 = selectedStoryOption.value) === null || _selectedStoryOption$4 === void 0 ? void 0 : _selectedStoryOption$4.id
        }
      });
      // reset selected webhook. Preserve undefined (not edited) to keep selector isInvalid value consistent
      setSelectedWebhookOption(current => current === undefined ? undefined : null);
    }
  }, [selectedStoryOption, webhook === null || webhook === void 0 ? void 0 : webhook.storyId, stories, toasts, editSubActionParams]);
  (0, _react.useEffect)(() => {
    var _selectedWebhookOptio;
    if (selectedWebhookOption === undefined && webhook !== null && webhook !== void 0 && webhook.id && webhooks) {
      // Set the initial selected webhook option from saved webhookId when webhooks are loaded
      const selectedWebhook = webhooks.find(({
        id
      }) => id === webhook.id);
      if (selectedWebhook) {
        setSelectedWebhookOption(createOption(selectedWebhook));
      } else {
        toasts.addWarning({
          title: i18n.WEBHOOK_NOT_FOUND_WARNING
        });
        editSubActionParams({
          webhook: {
            storyId: webhook === null || webhook === void 0 ? void 0 : webhook.storyId
          }
        });
      }
    }
    if (selectedWebhookOption !== undefined && (selectedWebhookOption === null || selectedWebhookOption === void 0 ? void 0 : (_selectedWebhookOptio = selectedWebhookOption.value) === null || _selectedWebhookOptio === void 0 ? void 0 : _selectedWebhookOptio.id) !== (webhook === null || webhook === void 0 ? void 0 : webhook.id)) {
      // Selected webhook changed, update webhook param, preserve storyId if the selected webhook has been reset
      editSubActionParams({
        webhook: selectedWebhookOption ? selectedWebhookOption.value : {
          storyId: webhook === null || webhook === void 0 ? void 0 : webhook.storyId
        }
      });
    }
  }, [selectedWebhookOption, webhook, webhooks, toasts, editSubActionParams]);
  (0, _react.useEffect)(() => {
    if (body !== bodyOption) {
      editSubActionParams({
        body: bodyOption
      });
    }
  }, [body, bodyOption, editSubActionParams]);
  const selectedStoryOptions = (0, _react.useMemo)(() => selectedStoryOption ? [selectedStoryOption] : [], [selectedStoryOption]);
  const selectedWebhookOptions = (0, _react.useMemo)(() => selectedWebhookOption ? [selectedWebhookOption] : [], [selectedWebhookOption]);
  const onChangeStory = (0, _react.useCallback)(([selected]) => {
    setSelectedStoryOption(selected !== null && selected !== void 0 ? selected : null);
  }, []);
  const onChangeWebhook = (0, _react.useCallback)(([selected]) => {
    setSelectedWebhookOption(selected !== null && selected !== void 0 ? selected : null);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.story,
    isInvalid: !!((_errors$story = errors.story) !== null && _errors$story !== void 0 && _errors$story.length) && selectedStoryOption !== undefined,
    label: i18n.STORY_LABEL,
    helpText: i18n.STORY_HELP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: !!((_errors$story2 = errors.story) !== null && _errors$story2 !== void 0 && _errors$story2.length) && selectedStoryOption !== undefined,
    "aria-label": i18n.STORY_PLACEHOLDER,
    placeholder: webhookUrl ? i18n.DISABLED_BY_WEBHOOK_URL_PLACEHOLDER : i18n.STORY_ARIA_LABEL,
    singleSelection: {
      asPlainText: true
    },
    options: storiesOptions,
    selectedOptions: selectedStoryOptions,
    onChange: onChangeStory,
    isDisabled: isLoadingStories || !!webhookUrl,
    isLoading: isLoadingStories,
    renderOption: renderStory,
    fullWidth: true,
    "data-test-subj": "tines-storySelector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.webhook,
    isInvalid: !!((_errors$webhook = errors.webhook) !== null && _errors$webhook !== void 0 && _errors$webhook.length) && selectedWebhookOption !== undefined,
    label: i18n.WEBHOOK_LABEL,
    helpText: i18n.WEBHOOK_HELP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: !!((_errors$webhook2 = errors.webhook) !== null && _errors$webhook2 !== void 0 && _errors$webhook2.length) && selectedWebhookOption !== undefined,
    "aria-label": i18n.WEBHOOK_ARIA_LABEL,
    placeholder: webhookUrl ? i18n.DISABLED_BY_WEBHOOK_URL_PLACEHOLDER : selectedStoryOption ? i18n.WEBHOOK_PLACEHOLDER : i18n.WEBHOOK_DISABLED_PLACEHOLDER,
    singleSelection: {
      asPlainText: true
    },
    options: webhooksOptions,
    selectedOptions: selectedWebhookOptions,
    onChange: onChangeWebhook,
    isDisabled: !selectedStoryOption || isLoadingWebhooks || !!webhookUrl,
    isLoading: isLoadingWebhooks,
    fullWidth: true,
    "data-test-subj": "tines-webhookSelector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 11
    }
  }))), showFallbackFrom != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 9
    }
  }, showFallbackFrom === 'error' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.WEBHOOK_URL_ERROR_FALLBACK_TITLE,
    color: "primary",
    "data-test-subj": "tines-fallbackCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 15
    }
  }, i18n.WEBHOOK_URL_ERROR_FALLBACK), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 15
    }
  })), (showFallbackFrom === 'Story' || showFallbackFrom === 'Webhook') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.WEBHOOK_URL_FALLBACK_TITLE,
    color: "primary",
    "data-test-subj": "tines-fallbackCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 15
    }
  }, i18n.WEBHOOK_URL_FALLBACK_TEXT(showFallbackFrom)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.webhookUrl,
    isInvalid: !!((_errors$webhookUrl = errors.webhookUrl) !== null && _errors$webhookUrl !== void 0 && _errors$webhookUrl.length),
    label: i18n.WEBHOOK_URL_LABEL,
    helpText: i18n.WEBHOOK_URL_HELP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: !!((_errors$webhookUrl2 = errors.webhookUrl) !== null && _errors$webhookUrl2 !== void 0 && _errors$webhookUrl2.length),
    placeholder: i18n.WEBHOOK_URL_PLACEHOLDER,
    value: webhookUrl,
    onChange: ev => {
      editSubActionParams({
        webhookUrl: ev.target.value
      });
    },
    fullWidth: true,
    "data-test-subj": "tines-webhookUrlInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 13
    }
  }))), isTest && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    paramsProperty: 'body',
    inputTargetValue: body,
    label: i18n.BODY_LABEL,
    ariaLabel: i18n.BODY_ARIA_LABEL,
    errors: errors.body,
    onDocumentsChange: setBodyOption,
    dataTestSubj: "tines-bodyJsonEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 11
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = TinesParamsFields;
module.exports = exports.default;