"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportContentPackFlyout = ImportContentPackFlyout;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_streams_privileges = require("../../../hooks/use_streams_privileges");
var _objects_list = require("./objects_list");
var _requests = require("./requests");
var _errors = require("../../../util/errors");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/content/import_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ImportContentPackFlyout({
  definition,
  onImport,
  onClose
}) {
  var _significantEvents$av;
  const {
    core: {
      http,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const {
    features: {
      significantEvents
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [file, setFile] = (0, _react.useState)(undefined);
  const [contentPackObjects, setContentPackObjects] = (0, _react.useState)(undefined);
  const [includedObjects, setIncludedObjects] = (0, _react.useState)({
    objects: {
      all: {}
    }
  });
  const [manifest, setManifest] = (0, _react.useState)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailDashboard.importContent', {
    defaultMessage: 'Import content pack'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: (0, _react2.css)`
          .euiFlyoutBody__overflowContent {
            height: 100%;
          }
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, !file && /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    css: (0, _react2.css)`
              height: 100%;
              > div {
                height: 100%;
              }
            `,
    id: 'streams-content-import',
    multiple: false,
    initialPromptText: _i18n.i18n.translate('xpack.streams.streamDetailDashboard.importContentFilePickerPrompt', {
      defaultMessage: 'You can drop your streams .zip content here and install them right away.'
    }),
    fullWidth: true,
    onChange: async files => {
      if (files !== null && files !== void 0 && files.length) {
        const archiveFile = files.item(0);
        if (!archiveFile) return;
        setFile(archiveFile);
        try {
          const contentPackParsed = await (0, _requests.previewContent)({
            http,
            definition,
            file: archiveFile
          });
          setManifest({
            name: contentPackParsed.name,
            version: contentPackParsed.version,
            description: contentPackParsed.description
          });
          setContentPackObjects(contentPackParsed.entries);
        } catch (err) {
          setFile(undefined);
          notifications.toasts.addError(err, {
            title: _i18n.i18n.translate('xpack.streams.failedToPreviewContentError', {
              defaultMessage: 'Failed to preview content pack'
            }),
            toastMessage: (0, _errors.getFormattedError)(err).message
          });
        }
      } else {
        setFile(undefined);
      }
    },
    display: 'large',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }), file && manifest && contentPackObjects ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "package",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 19
    }
  }, manifest.name, " ", manifest.version)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    color: "danger",
    onClick: () => {
      setFile(undefined);
      setManifest(undefined);
      setContentPackObjects(undefined);
      setIncludedObjects({
        objects: {
          all: {}
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_objects_list.ContentPackObjectsList, {
    objects: contentPackObjects,
    onSelectionChange: setIncludedObjects,
    significantEventsAvailable: (_significantEvents$av = significantEvents === null || significantEvents === void 0 ? void 0 : significantEvents.available) !== null && _significantEvents$av !== void 0 ? _significantEvents$av : false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.importContentPackFlyout.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppModalFooterButton",
    isDisabled: !file || (0, _helpers.isEmptyContentPack)(contentPackObjects !== null && contentPackObjects !== void 0 ? contentPackObjects : []) || !(0, _helpers.hasSelectedObjects)(includedObjects),
    isLoading: isLoading,
    fill: true,
    onClick: async () => {
      if (!file) return;
      setIsLoading(true);
      try {
        await (0, _requests.importContent)({
          http,
          file,
          definition,
          include: includedObjects
        });
        setIsLoading(false);
        setContentPackObjects(undefined);
        setFile(undefined);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.streams.exportContentPackFlyout.importSuccess', {
          defaultMessage: 'Content imported successfully'
        }));
        onImport();
      } catch (err) {
        setIsLoading(false);
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.streams.failedToImportContentError', {
            defaultMessage: 'Failed to import content pack'
          }),
          toastMessage: (0, _errors.getFormattedError)(err).message
        });
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.importContentPackFlyout.importToStream', {
    defaultMessage: 'Import to stream'
  }))))));
}