"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentPackObjectsList = ContentPackObjectsList;
var _react = _interopRequireWildcard(require("react"));
var _contentPacksSchema = require("@kbn/content-packs-schema");
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tree = require("./tree");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/content/objects_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ContentPackObjectsList({
  objects,
  onSelectionChange,
  significantEventsAvailable
}) {
  const streamEntries = objects.filter(entry => entry.type === 'stream');
  const [includeMappings, setIncludeMappings] = (0, _react.useState)((0, _helpers.containsMappings)(streamEntries));
  const [includeAssets, setIncludeAssets] = (0, _react.useState)((0, _helpers.containsAssets)(streamEntries));
  const [selection, setSelection] = (0, _react.useState)({
    ...objects.filter(entry => entry.type === 'stream').reduce((map, stream) => {
      map[stream.name] = {
        selected: true
      };
      return map;
    }, {})
  });
  const {
    rootEntry,
    descendants
  } = (0, _react.useMemo)(() => {
    if (objects.length === 0) {
      return {
        rootEntry: null,
        descendants: []
      };
    }
    const root = objects.find(entry => entry.type === 'stream' && entry.name === _contentPacksSchema.ROOT_STREAM_ID);
    const others = objects.filter(entry => entry.type === 'stream' && entry.name !== _contentPacksSchema.ROOT_STREAM_ID);
    return {
      rootEntry: root,
      descendants: others
    };
  }, [objects]);
  return !rootEntry ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "include-mappings",
    disabled: !(0, _helpers.containsMappings)(streamEntries),
    checked: includeMappings,
    label: _i18n.i18n.translate('xpack.streams.contentPackObjectsList.includeMappings', {
      defaultMessage: 'Include mappings of the root stream and selected streams partitions'
    }),
    onChange: () => {
      const include = !includeMappings;
      setIncludeMappings(include);
      onSelectionChange(toIncludedObjects({
        selection,
        objects: [rootEntry, ...descendants],
        includeAssets,
        includeMappings: include
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, significantEventsAvailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "include-all-assets",
    disabled: !(0, _helpers.containsAssets)(streamEntries),
    checked: includeAssets,
    label: _i18n.i18n.translate('xpack.streams.contentPackObjectsList.includeAllAssets', {
      defaultMessage: 'Include significant events of the root stream and selected streams partitions'
    }),
    onChange: () => {
      const include = !includeAssets;
      setIncludeAssets(include);
      onSelectionChange(toIncludedObjects({
        selection,
        objects: [rootEntry, ...descendants],
        includeAssets: include,
        includeMappings
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_tree.StreamTree, {
    streams: descendants,
    onSelectionChange: streamsSelection => {
      setSelection(streamsSelection);
      onSelectionChange(toIncludedObjects({
        selection: streamsSelection,
        objects: [rootEntry, ...descendants],
        includeAssets,
        includeMappings
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }));
}
function buildIncludedObjects(parent, selection, objects, includeAssets, includeMappings) {
  const children = Object.keys(selection).filter(key => {
    if (!selection[key].selected) {
      return false;
    }
    if (parent === _contentPacksSchema.ROOT_STREAM_ID) {
      return key !== _contentPacksSchema.ROOT_STREAM_ID && (0, _streamsSchema.getSegments)(key).length === 1;
    }
    return (0, _streamsSchema.isChildOf)(parent, key);
  });
  return {
    objects: {
      mappings: includeMappings,
      queries: !includeAssets ? [] : objects.find(({
        name
      }) => name === parent).request.queries.map(query => ({
        id: query.id
      })),
      routing: children.map(child => ({
        destination: child,
        ...buildIncludedObjects(child, selection, objects, includeAssets, includeMappings)
      }))
    }
  };
}
function toIncludedObjects({
  selection,
  objects,
  includeAssets,
  includeMappings
}) {
  return buildIncludedObjects(_contentPacksSchema.ROOT_STREAM_ID, selection, objects, includeAssets, includeMappings);
}