"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedFieldMappingOptions = void 0;
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _streamsSchema = require("@kbn/streams-schema");
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/flyout/advanced_field_mapping_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const label = _i18n.i18n.translate('xpack.streams.advancedFieldMappingOptions.label', {
  defaultMessage: 'Advanced field mapping parameters'
});
const AdvancedFieldMappingOptions = ({
  value,
  onChange,
  onValidate,
  isEditing
}) => {
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordionID'
  });
  const [hasParsingError, {
    on: markAsParsingError,
    off: resetParsingErrorFlag
  }] = (0, _reactHooks.useBoolean)(false);
  const isInvalid = hasParsingError || !getValidFlag(value);
  const jsonOptions = (0, _react.useMemo)(() => value ? JSON.stringify(value, null, 2) : '', [value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: isInvalid,
    error: isInvalid ? _i18n.i18n.translate('xpack.streams.advancedFieldMappingOptions.error', {
      defaultMessage: 'Invalid advanced field mapping parameters. It should be defined as a JSON object.'
    }) : undefined,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.advancedFieldMappingOptions.docs.label",
      defaultMessage: "Parameters can be defined with JSON. {link}",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAdvancedFieldMappingOptionsViewDocumentationLink",
          href: core.docLinks.links.elasticsearch.mappingParameters,
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.streams.indexPattern.randomSampling.learnMore",
          defaultMessage: "View documentation.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, isEditing ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 120,
    languageId: "json",
    value: jsonOptions,
    onChange: updatedValue => {
      try {
        const additionalParameters = updatedValue === '' ? undefined : JSON.parse(updatedValue);
        onChange(additionalParameters);
        if (onValidate) onValidate(getValidFlag(additionalParameters));
        resetParsingErrorFlag();
      } catch (error) {
        markAsParsingError();
        if (onValidate) onValidate(false);
      }
    },
    options: {
      automaticLayout: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, jsonOptions))));
};
exports.AdvancedFieldMappingOptions = AdvancedFieldMappingOptions;
const getValidFlag = additionalParameters => {
  return Boolean(!additionalParameters || additionalParameters === '' || (0, _streamsSchema.isSchema)(_streamsSchema.recursiveRecord, additionalParameters));
};