"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSource = void 0;
var _react = _interopRequireDefault(require("react"));
var _data_source_state_machine = require("../state_management/data_source_state_machine");
var _random_samples_data_source_card = require("./random_samples_data_source_card");
var _kql_samples_data_source_card = require("./kql_samples_data_source_card");
var _custom_samples_data_source_card = require("./custom_samples_data_source_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/data_sources_flyout/data_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataSource = ({
  dataSourceRef
}) => {
  const dataSourceType = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot.context.dataSource.type);
  switch (dataSourceType) {
    case 'random-samples':
      return /*#__PURE__*/_react.default.createElement(_random_samples_data_source_card.RandomSamplesDataSourceCard, {
        dataSourceRef: dataSourceRef,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 14
        }
      });
    case 'kql-samples':
      return /*#__PURE__*/_react.default.createElement(_kql_samples_data_source_card.KqlSamplesDataSourceCard, {
        dataSourceRef: dataSourceRef,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 14
        }
      });
    case 'custom-samples':
      return /*#__PURE__*/_react.default.createElement(_custom_samples_data_source_card.CustomSamplesDataSourceCard, {
        dataSourceRef: dataSourceRef,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 14
        }
      });
    default:
      return null;
  }
};
exports.DataSource = DataSource;