"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailEnrichmentContent = StreamDetailEnrichmentContent;
exports.StreamDetailEnrichmentContentImpl = StreamDetailEnrichmentContentImpl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kbn_url_state_context = require("../../../util/kbn_url_state_context");
var _use_kibana = require("../../../hooks/use_kibana");
var _management_bottom_bar = require("../management_bottom_bar");
var _simulation_playground = require("./simulation_playground");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _empty_prompts = require("./empty_prompts");
var _root_steps = require("./steps/root_steps");
var _streams_app_context_provider = require("../../streams_app_context_provider");
var _get_stream_type_from_definition = require("../../../util/get_stream_type_from_definition");
var _schema_changes_review_modal = require("../schema_editor/schema_changes_review_modal");
var _use_schema_fields = require("../schema_editor/hooks/use_schema_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/page_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MemoSimulationPlayground = /*#__PURE__*/_react.default.memo(_simulation_playground.SimulationPlayground);
function StreamDetailEnrichmentContent(props) {
  const {
    core,
    dependencies,
    services: {
      telemetryClient
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    streams: {
      streamsRepositoryClient
    }
  } = dependencies.start;
  const urlStateStorageContainer = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  return /*#__PURE__*/_react.default.createElement(_stream_enrichment_state_machine.StreamEnrichmentContextProvider, {
    definition: props.definition,
    refreshDefinition: props.refreshDefinition,
    core: core,
    data: data,
    streamsRepositoryClient: streamsRepositoryClient,
    urlStateStorageContainer: urlStateStorageContainer,
    telemetryClient: telemetryClient,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StreamDetailEnrichmentContentImpl, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
}
function StreamDetailEnrichmentContentImpl() {
  const context = (0, _use_kibana.useKibana)();
  const {
    appParams,
    core
  } = context;
  const {
    resetChanges,
    saveChanges
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const isReady = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches('ready'));
  const definition = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.definition);
  const canUpdate = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.can({
    type: 'stream.update'
  }));
  const detectedFields = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.detectedSchemaFields);
  const isSimulating = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.matches('runningSimulation'));
  const definitionFields = _react.default.useMemo(() => (0, _use_schema_fields.getDefinitionFields)(definition), [definition]);
  const hasDefinitionError = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => {
    var _snapshot$context$sim;
    return Boolean((_snapshot$context$sim = snapshot.context.simulation) === null || _snapshot$context$sim === void 0 ? void 0 : _snapshot$context$sim.definition_error);
  });
  const canManage = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.definition.privileges.manage);
  const isSavingChanges = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      stream: 'updating'
    }
  }));
  const hasChanges = canUpdate && !isSimulating;
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: hasChanges,
    history: appParams.history,
    http: core.http,
    navigateToUrl: core.application.navigateToUrl,
    openConfirm: core.overlays.openConfirm,
    shouldPromptOnReplace: false
  });
  if (!isReady) {
    return null;
  }
  const openConfirmationModal = () => {
    const overlay = core.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_streams_app_context_provider.StreamsAppContextProvider, {
      context: context,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_schema_changes_review_modal.SchemaChangesReviewModal, {
      fields: detectedFields,
      streamType: (0, _get_stream_type_from_definition.getStreamTypeFromDefinition)(definition.stream),
      definition: definition,
      storedFields: definitionFields,
      submitChanges: async () => saveChanges(),
      onClose: () => overlay.close(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    })), core), {
      maxWidth: 500
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: (0, _react2.css)`
          display: flex;
          overflow: hidden auto;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 40,
    minSize: "480px",
    tabIndex: 0,
    paddingSize: "l",
    css: verticalFlexCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(StepsEditor, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    indicator: "border",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 60,
    minSize: "300px",
    tabIndex: 0,
    paddingSize: "l",
    css: verticalFlexCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(MemoSimulationPlayground, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 17
    }
  }))))), hasChanges && /*#__PURE__*/_react.default.createElement(_management_bottom_bar.ManagementBottomBar, {
    onCancel: resetChanges,
    onConfirm: detectedFields.length > 0 && (0, _schema_changes_review_modal.getChanges)(detectedFields, definitionFields).length > 0 ? openConfirmationModal : saveChanges,
    isLoading: isSavingChanges,
    disabled: !hasChanges,
    insufficientPrivileges: !canManage,
    isInvalid: hasDefinitionError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }));
}
const StepsEditor = /*#__PURE__*/_react.default.memo(() => {
  const stepRefs = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.stepRefs);
  const simulation = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => snapshot.context.simulation);
  const errors = (0, _react.useMemo)(() => {
    if (!simulation) {
      return {
        ignoredFields: [],
        mappingFailures: [],
        definition_error: undefined
      };
    }
    const ignoredFieldsSet = new Set();
    const mappingFailuresSet = new Set();
    simulation.documents.forEach(doc => {
      doc.errors.forEach(error => {
        if (error.type === 'ignored_fields_failure') {
          error.ignored_fields.forEach(ignored => {
            ignoredFieldsSet.add(ignored.field);
          });
        }
        if (error.type === 'field_mapping_failure' && mappingFailuresSet.size < 2) {
          mappingFailuresSet.add(error.message);
        }
      });
    });
    return {
      ignoredFields: Array.from(ignoredFieldsSet),
      mappingFailures: Array.from(mappingFailuresSet),
      definition_error: simulation.definition_error
    };
  }, [simulation]);
  const hasSteps = !(0, _lodash.isEmpty)(stepRefs);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasSteps ? /*#__PURE__*/_react.default.createElement(_root_steps.RootSteps, {
    stepRefs: stepRefs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_empty_prompts.NoStepsEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 55
    }
  }), (!(0, _lodash.isEmpty)(errors.ignoredFields) || !(0, _lodash.isEmpty)(errors.mappingFailures) || errors.definition_error) && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }, errors.definition_error && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    grow: false,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.definitionError",
    defaultMessage: "Please fix this error before saving: {error}",
    values: {
      error: errors.definition_error.message
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 19
    }
  })))), !(0, _lodash.isEmpty)(errors.ignoredFields) && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    grow: false,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "ignored-fields-failures-accordion",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ignoredFieldsFailure.title', {
      defaultMessage: 'Malformed fields detected.'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.ignoredFieldsFailure.fieldsList",
    defaultMessage: "Some fields are malformed and won\u2019t be stored correctly: {fields}",
    values: {
      fields: errors.ignoredFields.map(field => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        key: field,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 29
        }
      }, field), ' '))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ignoredFieldsFailure.causesLabel', {
    defaultMessage: 'This can happen due to type mismatches or fields exceeding configured limits.'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.ignoredFieldsFailure.suggestionsLabel', {
    defaultMessage: 'Check your field mappings, add processors to normalize values, or remove the conflicting fields.'
  }))))), !(0, _lodash.isEmpty)(errors.mappingFailures) && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    grow: false,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "mapping-failures-accordion",
    initialIsOpen: true,
    buttonContent: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.fieldMappingsFailure.title', {
      defaultMessage: 'Field conflicts during simulation'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.fieldMappingsFailure.fieldsList",
    defaultMessage: "These are some mapping failures that occurred during the simulation:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 19
    }
  }, errors.mappingFailures.map((failureMessage, id) => /*#__PURE__*/_react.default.createElement("li", {
    key: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: clampTwoLines,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 25
    }
  }, failureMessage)))))))));
});
const verticalFlexCss = (0, _react2.css)`
  display: flex;
  flex-direction: column;
`;
const clampTwoLines = (0, _react2.css)`
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
  text-overflow: ellipsis;
`;