"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUpsertStreamActor = createUpsertStreamActor;
exports.createUpsertStreamSuccessNofitier = exports.createUpsertStreamFailureNofitier = void 0;
var _streamsSchema = require("@kbn/streams-schema");
var _xstate = require("xstate5");
var _i18n = require("@kbn/i18n");
var _streamlang = require("@kbn/streamlang");
var _get_stream_type_from_definition = require("../../../../../util/get_stream_type_from_definition");
var _errors = require("../../../../../util/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createUpsertStreamActor({
  streamsRepositoryClient,
  telemetryClient
}) {
  return (0, _xstate.fromPromise)(async ({
    input,
    signal
  }) => {
    const response = await streamsRepositoryClient.fetch(`PUT /api/streams/{name}/_ingest 2023-10-31`, {
      signal,
      params: {
        path: {
          name: input.definition.stream.name
        },
        body: _streamsSchema.Streams.WiredStream.GetResponse.is(input.definition) ? {
          ingest: {
            ...input.definition.stream.ingest,
            processing: (0, _streamlang.convertUIStepsToDSL)(input.steps),
            ...(input.fields && {
              wired: {
                ...input.definition.stream.ingest.wired,
                fields: input.fields
              }
            })
          }
        } : {
          ingest: {
            ...input.definition.stream.ingest,
            processing: (0, _streamlang.convertUIStepsToDSL)(input.steps),
            ...(input.fields && {
              classic: {
                ...input.definition.stream.ingest.classic,
                field_overrides: input.fields
              }
            })
          }
        }
      }
    });
    const processorsCount = input.steps.filter(step => (0, _streamlang.isActionBlock)(step)).length;
    telemetryClient.trackProcessingSaved({
      processors_count: processorsCount,
      stream_type: (0, _get_stream_type_from_definition.getStreamTypeFromDefinition)(input.definition.stream)
    });
    return response;
  });
}
const createUpsertStreamSuccessNofitier = ({
  toasts
}) => () => {
  toasts.addSuccess(_i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.saveChangesSuccess', {
    defaultMessage: "Stream's processors updated"
  }));
};
exports.createUpsertStreamSuccessNofitier = createUpsertStreamSuccessNofitier;
const createUpsertStreamFailureNofitier = ({
  toasts
}) => params => {
  const event = params.event;
  const formattedError = (0, _errors.getFormattedError)(event.error);
  toasts.addError(formattedError, {
    title: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.saveChangesError', {
      defaultMessage: "An issue occurred saving processors' changes."
    }),
    toastMessage: formattedError.message
  });
};
exports.createUpsertStreamFailureNofitier = createUpsertStreamFailureNofitier;