"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorStatusIndicator = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/processor_status_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProcessorStatusIndicator = ({
  stepRef,
  stepsProcessingSummaryMap
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!stepsProcessingSummaryMap) return null;
  const stepId = stepRef.id;
  const stepStatus = stepsProcessingSummaryMap.get(stepId);
  let variant = null;
  if (stepStatus === 'disabled.processorBeforePersisted') {
    const name = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.mixedProcessorTooltip', {
      defaultMessage: 'Simulation is disabled when new processors are placed between previously made processors. To enable simulation, move all new processors to the end.'
    });
    variant = {
      type: 'dot',
      color: 'subdued',
      content: name,
      size: 'l'
    };
  } else if (stepStatus === 'skipped.followsProcessorBeingEdited' || stepStatus === 'skipped.createdInPreviousSimulation') {
    const name = stepStatus === 'skipped.followsProcessorBeingEdited' ? _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.skippedNewProcessorTooltip', {
      defaultMessage: 'Processor skipped because it follows a processor being edited.'
    }) : _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.skippedConfiguredProcessorTooltip', {
      defaultMessage: 'Processor skipped because it was created in a previous simulation session.'
    });
    variant = {
      type: 'dot',
      color: 'warning',
      content: name,
      size: 'l'
    };
  } else {
    if (stepStatus === 'running') {
      const name = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulatingProcessorTooltip', {
        defaultMessage: 'Simulating processor'
      });
      variant = {
        content: name,
        type: () => /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 79,
            columnNumber: 21
          }
        }),
        color: euiTheme.colors.backgroundBasePrimary,
        size: 's'
      };
    } else if (stepStatus === 'pending') {
      const name = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.pendingProcessorTooltip', {
        defaultMessage: 'Pending simulation.'
      });
      variant = {
        type: 'dot',
        color: 'danger',
        content: name,
        size: 'l'
      };
    } else if (stepStatus === 'failed') {
      const name = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.failingProcessorTooltip', {
        defaultMessage: 'Processor configuration failed simulation.'
      });
      variant = {
        type: 'crossInCircle',
        color: 'danger',
        content: name,
        size: 'm'
      };
    } else if (stepStatus === 'successful') {
      const name = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.newProcessorTooltip', {
        defaultMessage: 'Processor configuration simulated successfully.'
      });
      variant = {
        type: 'checkCircle',
        color: 'success',
        content: name,
        size: 'm'
      };
    }
  }
  if (!variant) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, (0, _extends2.default)({}, variant, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 10
    }
  }));
};
exports.ProcessorStatusIndicator = ProcessorStatusIndicator;