"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueField = exports.SetValueOrCopyFromField = exports.CopyFromField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/set/set_value_or_copy_from_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VALUE_FIELD = 'value';
const COPY_FROM_FIELD = 'copy_from';
const ValueField = ({
  toggleCustom
}) => {
  const {
    register,
    unregister
  } = (0, _reactHookForm.useFormContext)();
  const {
    ref,
    ...inputProps
  } = register(VALUE_FIELD, {
    required: true
  });
  (0, _react.useEffect)(() => {
    return () => {
      unregister(VALUE_FIELD);
    };
  }, [unregister]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setValueFieldLabel', {
      defaultMessage: 'Value'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setValueFieldHelpText",
      defaultMessage: "The value to be set for the field. Supports template snippets.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleCustom,
      "data-test-subj": "toggleCopyFromField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setToggleCopyFromFieldLabel",
      defaultMessage: "Use copy from field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 13
      }
    }))),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, inputProps, {
    inputRef: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  })));
};
exports.ValueField = ValueField;
const CopyFromField = ({
  toggleCustom
}) => {
  const {
    register,
    unregister
  } = (0, _reactHookForm.useFormContext)();
  const {
    ref,
    ...inputProps
  } = register(COPY_FROM_FIELD, {
    required: true
  });
  (0, _react.useEffect)(() => {
    return () => {
      unregister(COPY_FROM_FIELD);
    };
  }, [unregister]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setCopyFromFieldLabel', {
      defaultMessage: 'Copy from'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setCopyFromFieldHelpText",
      defaultMessage: "Field to copy into {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 79,
            columnNumber: 20
          }
        }, 'Field')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: toggleCustom,
      "data-test-subj": "toggleValueField",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setToggleValueFieldLabel",
      defaultMessage: "Use value field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    }))),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, inputProps, {
    inputRef: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  })));
};
exports.CopyFromField = CopyFromField;
const SetValueOrCopyFromField = () => {
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const isCopyFromDefined = getValues(COPY_FROM_FIELD) !== undefined && getValues(COPY_FROM_FIELD) !== '';
  const [isCopyFromField, setIsCopyFromField] = (0, _react.useState)(isCopyFromDefined);
  const toggleCustom = (0, _react.useCallback)(() => {
    setIsCopyFromField(prev => !prev);
  }, []);
  return !isCopyFromField ? /*#__PURE__*/_react.default.createElement(ValueField, {
    toggleCustom: toggleCustom,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(CopyFromField, {
    toggleCustom: toggleCustom,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  });
};
exports.SetValueOrCopyFromField = SetValueOrCopyFromField;