"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionCard = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _base_metric_card = require("../../common/base_metric_card");
var _format_size_units = require("../../helpers/format_size_units");
var _ilm_link = require("../ilm_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/cards/retention_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RetentionCard = ({
  definition,
  openEditModal
}) => {
  const lifecycle = definition.effective_lifecycle;
  const isRootStream = (0, _streamsSchema.isRoot)(definition.stream.name);
  const isWiredStream = _streamsSchema.Streams.WiredStream.GetResponse.is(definition);
  const isInheritingLifecycle = (0, _streamsSchema.isInheritLifecycle)(definition.stream.ingest.lifecycle);
  const getRetentionOrigin = () => {
    if (isWiredStream) {
      if (isInheritingLifecycle) {
        return _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.inheritingFromParent', {
          defaultMessage: 'Inherit from parent'
        });
      } else if (!isRootStream) {
        return _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.overrideParent', {
          defaultMessage: 'Override parent'
        });
      }
      return null;
    }
    return isInheritingLifecycle ? _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.inheritingIndexTemplate', {
      defaultMessage: 'Inherit from index template'
    }) : _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.overrideIndexTemplate', {
      defaultMessage: 'Override index template'
    });
  };
  const retentionOrigin = getRetentionOrigin();
  const getMetrics = () => {
    const baseSubtitles = [];
    let data;
    if ((0, _streamsSchema.isIlmLifecycle)(lifecycle)) {
      baseSubtitles.push(_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.retention.ilmPolicy', {
        defaultMessage: 'ILM policy'
      }));
      data = /*#__PURE__*/_react.default.createElement(_ilm_link.IlmLink, {
        lifecycle: lifecycle,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 14
        }
      });
    } else if ((0, _streamsSchema.isDslLifecycle)(lifecycle)) {
      const formattedRetention = (0, _format_size_units.getTimeSizeAndUnitLabel)(lifecycle.dsl.data_retention);
      const isIndefiniteRetention = formattedRetention === undefined;
      baseSubtitles.push(isIndefiniteRetention ? _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.retention.indefinite', {
        defaultMessage: 'Indefinite'
      }) : _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.retention.custom', {
        defaultMessage: 'Custom period'
      }));
      data = formattedRetention !== null && formattedRetention !== void 0 ? formattedRetention : '∞';
    } else if ((0, _streamsSchema.isDisabledLifecycle)(lifecycle)) {
      baseSubtitles.push(_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.retention.disabled', {
        defaultMessage: 'Disabled'
      }));
      data = '∞';
    } else {
      data = '—';
    }
    const subtitles = retentionOrigin ? [...baseSubtitles, retentionOrigin] : baseSubtitles;
    return [{
      data,
      subtitle: subtitles,
      'data-test-subj': 'retention'
    }];
  };
  const title = _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.retention.title', {
    defaultMessage: 'Retention'
  });
  const metrics = getMetrics();
  return /*#__PURE__*/_react.default.createElement(_base_metric_card.BaseMetricCard, {
    title: title,
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "streamsAppRetentionMetadataEditDataRetentionButton",
      size: "s",
      onClick: openEditModal,
      disabled: !definition.privileges.lifecycle,
      iconType: "pencil",
      "aria-label": _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.editDataRetentionAriaLabel', {
        defaultMessage: 'Edit data retention'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.editDataRetention', {
      defaultMessage: 'Edit data retention'
    })),
    metrics: metrics,
    "data-test-subj": "retentionCard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  });
};
exports.RetentionCard = RetentionCard;