"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageSizeCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _base_metric_card = require("../../common/base_metric_card");
var _format_bytes = require("../../helpers/format_bytes");
var _insufficient_privileges = require("../../../../insufficient_privileges/insufficient_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/cards/storage_size_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StorageSizeCard = ({
  hasMonitorPrivileges,
  stats,
  statsError
}) => {
  const metric = [{
    data: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: hasMonitorPrivileges,
      title: _i18n.i18n.translate('xpack.streams.storageSizeCard.privilegesWarningIconWrapper.storagesizeLabel', {
        defaultMessage: 'storageSize'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, statsError || !stats || stats.sizeBytes === undefined ? '-' : (0, _format_bytes.formatBytes)(stats.sizeBytes)),
    subtitle: hasMonitorPrivileges ? _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.storageSize.docs', {
      defaultMessage: '{totalDocs} documents',
      values: {
        totalDocs: statsError || !stats || stats.totalDocs === undefined ? '-' : (0, _eui.formatNumber)(stats.totalDocs, '0,0')
      }
    }) : null,
    'data-test-subj': 'storageSize'
  }];
  const inaccurateMetric = Boolean((stats === null || stats === void 0 ? void 0 : stats.hasFailureStore) && !stats.userPrivileges.canManageFailureStore);
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailLifecycle.storageSize.title",
    defaultMessage: "Storage size {tooltipIcon}",
    "data-test-subj": "storageSize-title",
    values: {
      tooltipIcon: inaccurateMetric && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "question",
        content: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.storageSize.tooltip', {
          defaultMessage: 'The storage size includes the failure store.'
        }),
        "data-test-subj": "inaccurateMetricTooltip",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_base_metric_card.BaseMetricCard, {
    title: title,
    metrics: metric,
    "data-test-subj": "storageSize",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 10
    }
  });
};
exports.StorageSizeCard = StorageSizeCard;