"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ingestionRateQuery = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ingestionRateQuery = ({
  index,
  start,
  end,
  timestampField = '@timestamp',
  bucketCount = 10
}) => {
  const startDate = _datemath.default.parse(start);
  const endDate = _datemath.default.parse(end);
  if (!startDate || !endDate) {
    throw new Error(`Expected a valid start and end date but got [start: ${start} | end: ${end}]`);
  }
  const intervalInSeconds = Math.max(Math.round(endDate.diff(startDate, 'seconds') / bucketCount), 1);
  return {
    index,
    track_total_hits: false,
    body: {
      size: 0,
      query: {
        bool: {
          filter: [{
            range: {
              [timestampField]: {
                gte: start,
                lte: end
              }
            }
          }]
        }
      },
      aggs: {
        docs_count: {
          date_histogram: {
            field: timestampField,
            fixed_interval: `${intervalInSeconds}s`,
            min_doc_count: 0
          }
        }
      }
    }
  };
};
exports.ingestionRateQuery = ingestionRateQuery;