"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rolloverCondition = rolloverCondition;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function rolloverCondition(rollover) {
  const conditions = [(rollover === null || rollover === void 0 ? void 0 : rollover.max_age) && _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.rolloverConditionMaxAge', {
    defaultMessage: 'max age {maxAge}',
    values: {
      maxAge: rollover.max_age
    }
  }), (rollover === null || rollover === void 0 ? void 0 : rollover.max_docs) && _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.rolloverConditionMaxDocs', {
    defaultMessage: 'max docs {maxDocs}',
    values: {
      maxDocs: rollover.max_docs
    }
  }), (rollover === null || rollover === void 0 ? void 0 : rollover.max_primary_shard_docs) && _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.rolloverConditionMaxPrimaryShardDocs', {
    defaultMessage: 'primary shard docs {shardDocs}',
    values: {
      shardDocs: rollover.max_primary_shard_docs
    }
  }), (rollover === null || rollover === void 0 ? void 0 : rollover.max_primary_shard_size) && _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.rolloverConditionMaxPrimaryShardSize', {
    defaultMessage: 'primary shard size {shardSize}',
    values: {
      shardSize: rollover.max_primary_shard_size
    }
  }), (rollover === null || rollover === void 0 ? void 0 : rollover.max_size) && _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.rolloverConditionMaxSize', {
    defaultMessage: 'index size {maxSize}',
    values: {
      maxSize: rollover.max_size
    }
  })].filter(Boolean);
  return conditions.join(_i18n.i18n.translate('xpack.streams.streamDetailLifecycle.rolloverConditionOr', {
    defaultMessage: ' or '
  }));
}