"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkedDashboardsView = LinkedDashboardsView;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_dashboards_fetch = require("../../../hooks/use_dashboards_fetch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/linked_dashboards_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LinkedDashboardsView({
  definition
}) {
  var _dashboardsFetch$valu;
  const context = (0, _use_kibana.useKibana)();
  const dashboardsFetch = (0, _use_dashboards_fetch.useDashboardsFetch)(definition.stream.name);
  const dashboardsLocator = context.dependencies.start.share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)(null);
  if (dashboardsFetch.loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 12
      }
    });
  }
  if (selectedDashboard === null && (_dashboardsFetch$valu = dashboardsFetch.value) !== null && _dashboardsFetch$valu !== void 0 && _dashboardsFetch$valu.dashboards.length) {
    setSelectedDashboard(dashboardsFetch.value.dashboards[0].id);
  }
  return dashboardsFetch.value && dashboardsFetch.value.dashboards.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(DashboardSelector, {
    dashboards: dashboardsFetch.value.dashboards,
    onSelect: setSelectedDashboard,
    selectedDashboard: selectedDashboard,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  })), dashboardsLocator && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: dashboardsLocator.getRedirectUrl({
      dashboardId: selectedDashboard
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, "Open in Dashboards"))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), selectedDashboard && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.DashboardRenderer, {
    savedObjectId: selectedDashboard,
    getCreationOptions: async () => ({
      getInitialInput: () => ({
        viewMode: 'view',
        timeRange: {
          from: 'now-15m',
          to: 'now'
        }
      })
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }))) : _i18n.i18n.translate('xpack.streams.linkedDashboardsView.noLinkedDashboardsLabel', {
    defaultMessage: 'No linked dashboards'
  });
}
function DashboardSelector({
  dashboards,
  onSelect,
  selectedDashboard
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    bordered: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, dashboards.map(dashboard => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: dashboard.id,
    label: dashboard.title,
    onClick: () => onSelect(dashboard.id),
    isActive: dashboard.id === selectedDashboard,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  })));
}