"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/stream_features/table_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TableTitle = ({
  pageIndex,
  pageSize,
  total,
  label
}) => {
  const start = Math.min(pageIndex * pageSize + 1, total);
  const end = Math.min(start + pageSize - 1, total);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.tableTitle.showing",
    defaultMessage: "Showing {count} of {total} {label}",
    values: {
      count: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 13
        }
      }, start, "-", end),
      total,
      label: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 18
        }
      }, label)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }));
};
exports.TableTitle = TableTitle;