"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentStreamEntry = CurrentStreamEntry;
var _eui = require("@elastic/eui");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/current_stream_entry.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CurrentStreamEntry({
  definition
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const ancestors = (0, _streamsSchema.getAncestorsAndSelf)(definition.stream.name);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    className: (0, _css.css)`
          overflow: hidden;
          border-radius: ${euiTheme.size.s};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, ancestors.map((streamName, index) => {
    const isLast = index === ancestors.length - 1;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: streamName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      wrap: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: isLast ? 'folderOpen' : 'folderClosed',
      size: "m",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 21
      }
    }, isLast ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 25
      }
    }, streamName) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: router.link('/{key}/management/{tab}', {
        path: {
          key: streamName,
          tab: 'partitioning'
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      css: (0, _css.css)`
                              font-weight: ${euiTheme.font.weight.bold};
                            `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 27
      }
    }, streamName))))), !isLast && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowRight",
      size: "s",
      color: "subdued",
      css: (0, _css.css)`
                        margin: 0 ${euiTheme.size.xs};
                      `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 21
      }
    })));
  }))));
}