"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerateSuggestionButton = exports.AdditionalChargesCallout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/review_suggestions_form/generate_suggestions_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GenerateSuggestionButton = ({
  aiFeatures,
  onClick,
  ...rest
}) => {
  const {
    core: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const splitButtonPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'splitButtonPopover'
  });
  if (!aiFeatures.enabled) {
    if (aiFeatures.couldBeEnabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.aiAssistantNotEnabledTooltip', {
          defaultMessage: 'AI Assistant features are not enabled. To enable features, add an AI connector on the management page.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: http.basePath.prepend(`/app/management/insightsAndAlerting/triggersActionsConnectors/connectors`),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.aiAssistantNotEnabled', {
        defaultMessage: 'Enable AI Assistant features'
      })));
    }
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    size: "s",
    iconType: "sparkles",
    "data-test-subj": "streamsAppGenerateSuggestionButton",
    onClick: () => onClick(aiFeatures.genAiConnectors.selectedConnector),
    isDisabled: !aiFeatures.genAiConnectors.selectedConnector || rest.isDisabled
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }))), aiFeatures.genAiConnectors.connectors && aiFeatures.genAiConnectors.connectors.length >= 2 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: splitButtonPopoverId,
    isOpen: isPopoverOpen,
    closePopover: () => closePopover(),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "streamsAppGenerateSuggestionButtonMoreButton",
      onClick: togglePopover,
      display: "base",
      size: "s",
      iconType: "boxesVertical",
      isDisabled: rest.isDisabled || rest.isLoading,
      "aria-label": _i18n.i18n.translate('xpack.streams.refreshButton.euiButtonIcon.moreLabel', {
        defaultMessage: 'More'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 19
      }
    }),
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: aiFeatures.genAiConnectors.connectors.map(connector => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: connector.id,
      icon: connector.id === aiFeatures.genAiConnectors.selectedConnector ? 'check' : 'empty',
      onClick: () => {
        aiFeatures.genAiConnectors.selectConnector(connector.id);
        closePopover();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 21
      }
    }, connector.name)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  })))));
};
exports.GenerateSuggestionButton = GenerateSuggestionButton;
const AdditionalChargesCallout = ({
  aiFeatures
}) => {
  const {
    core: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    onDismiss: () => aiFeatures.acknowledgeAdditionalCharges(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.managedConnectorTooltip",
    defaultMessage: "Elastic Managed LLM is the new default for generating patterns and incurs <costLink>additional charges</costLink>. Other LLM connectors remain available. <learnMoreLink>Learn more</learnMoreLink>",
    values: {
      costLink: (...chunks) => {
        var _docLinks$links, _docLinks$links$obser;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$obser = _docLinks$links.observability) === null || _docLinks$links$obser === void 0 ? void 0 : _docLinks$links$obser.elasticManagedLlmUsageCost,
          target: "_blank",
          rel: "noopener noreferrer",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 157,
            columnNumber: 13
          }
        }, chunks);
      },
      learnMoreLink: (...chunks) => {
        var _docLinks$links2, _docLinks$links2$obse;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links2 = docLinks.links) === null || _docLinks$links2 === void 0 ? void 0 : (_docLinks$links2$obse = _docLinks$links2.observability) === null || _docLinks$links2$obse === void 0 ? void 0 : _docLinks$links2$obse.elasticManagedLlm,
          target: "_blank",
          rel: "noopener noreferrer",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 13
          }
        }, chunks);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }));
};
exports.AdditionalChargesCallout = AdditionalChargesCallout;