"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewTab = OverviewTab;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/group_stream_modification_flyout/overview_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OverviewTab({
  formData,
  setFormData,
  existingStream,
  availableStreams
}) {
  const handleInputChange = e => {
    setFormData({
      ...formData,
      [e.target.name]: e.target.value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !existingStream && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.streamNameLabel', {
      defaultMessage: 'Stream name'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    value: formData.name,
    onChange: handleInputChange,
    disabled: existingStream,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "description",
    value: formData.description,
    onChange: handleInputChange,
    rows: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(MetadataEditor, {
    onChange: metadata => {
      setFormData({
        ...formData,
        metadata
      });
    },
    value: formData.metadata,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.tagsLabel', {
      defaultMessage: 'Tags'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    selectedOptions: formData.tags,
    onCreateOption: searchValue => {
      const newOption = {
        label: searchValue
      };
      setFormData({
        ...formData,
        tags: [...formData.tags, newOption]
      });
    },
    onChange: options => {
      setFormData({
        ...formData,
        tags: options
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.membersLabel', {
      defaultMessage: 'Members'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: availableStreams,
    selectedOptions: formData.members,
    onChange: options => {
      setFormData({
        ...formData,
        members: options
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  })));
}
function MetadataEditor({
  onChange,
  value
}) {
  const [pairs, setPairs] = _react.default.useState(Object.entries(value).map(([key, val]) => ({
    key,
    value: val
  })));
  const handlePairChange = (index, field, fieldValue) => {
    const newPairs = pairs.map((pair, i) => i === index ? {
      ...pair,
      [field]: fieldValue
    } : pair);
    setPairs(newPairs);
    const metadata = Object.fromEntries(newPairs.filter(pair => pair.key && pair.value).map(pair => [pair.key, pair.value]));
    onChange(metadata);
  };
  const handleAddPair = () => {
    setPairs([...pairs, {
      key: '',
      value: ''
    }]);
  };
  const handleRemovePair = index => {
    const newPairs = pairs.filter((_, i) => i !== index);
    setPairs(newPairs);
    const metadata = Object.fromEntries(newPairs.filter(pair => pair.key && pair.value).map(pair => [pair.key, pair.value]));
    onChange(metadata);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.metadataLabel', {
      defaultMessage: 'Metadata'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "plusInCircle",
      "aria-label": _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.addMetadataButtonLabel', {
        defaultMessage: 'Add'
      }),
      onClick: handleAddPair,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 11
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pairs.map((pair, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.metadataKeyPlaceholder', {
      defaultMessage: 'Key'
    }),
    value: pair.key,
    onChange: e => handlePairChange(index, 'key', e.target.value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.metadataValuePlaceholder', {
      defaultMessage: 'Value'
    }),
    value: pair.value,
    onChange: e => handlePairChange(index, 'value', e.target.value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.removeMetadataButtonLabel', {
      defaultMessage: 'Remove'
    }),
    onClick: () => handleRemovePair(index),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  }))), pairs.length === 0 && _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.noMetadataLabel', {
    defaultMessage: 'No metadata added'
  })));
}