"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailDataQuality = StreamDetailDataQuality;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../hooks/use_kibana");
var _use_dataset_quality_controller = require("../../hooks/use_dataset_quality_controller");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_data_quality/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamDetailDataQuality({
  definition
}) {
  const {
    datasetQuality
  } = (0, _use_kibana.useKibana)().dependencies.start;
  const controller = (0, _use_dataset_quality_controller.useDatasetQualityController)(definition);
  return controller ? /*#__PURE__*/_react.default.createElement(datasetQuality.DatasetQualityDetails, {
    controller: controller,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }) : _i18n.i18n.translate('xpack.streams.streamQualityDetails.loadingMessage', {
    defaultMessage: 'Loading...'
  });
}