"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlowSelector = FlowSelector;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/flow_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FlowSelector({
  selected,
  updateSelected,
  isSubmitting
}) {
  const flowRadioGroupId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'flowRadioGroup'
  });
  const manualCheckableCardId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'manualCheckableCard'
  });
  const aiCheckableCardId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'aiCheckableCard'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: aiCheckableCardId,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.aiOptionLabel', {
      defaultMessage: 'Generate significant events with AI'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      component: "p",
      color: "subdued",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.aiOptionDescription', {
      defaultMessage: 'Let AI suggest queries for significant events based on your data patterns, and select from the suggestions.'
    }))),
    name: flowRadioGroupId,
    value: "ai",
    checked: selected === 'ai',
    onChange: () => updateSelected('ai'),
    disabled: isSubmitting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: manualCheckableCardId,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.manualOptionLabel', {
      defaultMessage: 'Create significant events from a query'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      component: "p",
      color: "subdued",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.addSignificantEventFlyout.manualOptionDescription', {
      defaultMessage: 'Write a query to find and add a known significant event.'
    }))),
    name: flowRadioGroupId,
    value: "manual",
    checked: selected === 'manual',
    onChange: () => updateSelected('manual'),
    disabled: isSubmitting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
}