"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneratedEventPreview = GeneratedEventPreview;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _preview_data_spark_plot = require("../common/preview_data_spark_plot");
var _validate_query = require("../common/validate_query");
var _uncontrolled_streams_app_bar = require("../../../streams_app_search_bar/uncontrolled_streams_app_bar");
var _default_query = require("../utils/default_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/generated_flow_form/generated_event_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GeneratedEventPreview({
  definition,
  query: initialQuery,
  isEditing,
  setIsEditing,
  onSave,
  features,
  dataViews
}) {
  var _options$find;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [query, setQuery] = (0, _react.useState)(initialQuery);
  const options = features.map(feature => ({
    value: feature,
    inputDisplay: feature.name
  })).concat([{
    value: _default_query.NO_FEATURE,
    inputDisplay: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.manualFlow.noFeatureOptionLabel', {
      defaultMessage: 'No feature'
    })
  }]);
  const [touched, setTouched] = (0, _react.useState)({
    title: false,
    feature: false,
    kql: false
  });
  const validation = (0, _validate_query.validateQuery)(query);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: '100%',
      padding: `${euiTheme.size.m} ${euiTheme.size.m} ${euiTheme.size.m} 0`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    className: (0, _css.css)`
            & .euiFormLabel {
              margin: auto 0;
            }
          `,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generatedEventPreview.formFieldTitleLabel', {
      defaultMessage: 'Title'
    })),
    labelAppend: isEditing ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "flexEnd",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      onClick: () => {
        setIsEditing(false);
        setQuery(initialQuery);
        setTouched({
          title: false,
          feature: false,
          kql: false
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generatedEventPreview.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "save",
      disabled: validation.title.isInvalid || validation.kql.isInvalid,
      onClick: () => {
        setIsEditing(false);
        onSave(query);
        setTouched({
          title: false,
          feature: false,
          kql: false
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generatedEventPreview.saveButtonLabel', {
      defaultMessage: 'Save'
    }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: () => {
        setIsEditing(true);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generatedEventPreview.editButtonLabel', {
      defaultMessage: 'Edit'
    }))
  }, touched.title && {
    ...validation.title
  }, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    value: query === null || query === void 0 ? void 0 : query.title,
    disabled: !isEditing,
    onChange: event => {
      setQuery({
        ...query,
        title: event.currentTarget.value
      });
      setTouched(prev => ({
        ...prev,
        title: true
      }));
    },
    onBlur: () => {
      setTouched(prev => ({
        ...prev,
        title: true
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generatedEventPreview.formFieldFeatureLabel', {
      defaultMessage: 'Feature'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: (_options$find = options.find(option => {
      var _query$feature;
      return option.value.name === ((_query$feature = query.feature) === null || _query$feature === void 0 ? void 0 : _query$feature.name);
    })) === null || _options$find === void 0 ? void 0 : _options$find.value,
    onBlur: () => {
      setTouched(prev => ({
        ...prev,
        feature: true
      }));
    },
    onChange: value => {
      setQuery({
        ...query,
        feature: {
          name: value.name,
          filter: value.filter
        }
      });
      setTouched(prev => ({
        ...prev,
        feature: true
      }));
    },
    placeholder: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generatedEventPreview.featurePlaceholder', {
      defaultMessage: 'Select feature'
    }),
    disabled: !isEditing,
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generatedEventPreview.formFieldQueryLabel', {
      defaultMessage: 'Query'
    }))
  }, touched.kql && {
    ...validation.kql
  }, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_uncontrolled_streams_app_bar.UncontrolledStreamsAppSearchBar, {
    query: query.kql ? {
      language: 'kuery',
      ...query.kql
    } : {
      language: 'kuery',
      query: ''
    },
    onQueryChange: () => {
      setTouched(prev => ({
        ...prev,
        kql: true
      }));
    },
    onQuerySubmit: next => {
      var _next$query;
      setQuery({
        ...query,
        kql: {
          query: typeof ((_next$query = next.query) === null || _next$query === void 0 ? void 0 : _next$query.query) === 'string' ? next.query.query : ''
        }
      });
      setTouched(prev => ({
        ...prev,
        kql: true
      }));
    },
    showQueryInput: true,
    showSubmitButton: false,
    isDisabled: !isEditing,
    placeholder: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.generatedEventPreview.queryPlaceholder', {
      defaultMessage: 'Enter query'
    }),
    indexPatterns: dataViews,
    submitOnBlur: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_preview_data_spark_plot.PreviewDataSparkPlot, {
    definition: definition,
    query: query,
    isQueryValid: !validation.kql.isInvalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }));
}