"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilteredSigEvents = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilteredSigEvents = (response, queryString) => {
  const significantEvents = (0, _react.useMemo)(() => {
    const values = response !== null && response !== void 0 ? response : [];
    if (queryString) {
      const lowerCaseQuery = queryString.toLowerCase();
      return values.filter(item => {
        var _item$query$feature, _item$query$feature2, _item$query$feature2$;
        return item.title.toLowerCase().includes(lowerCaseQuery) || ((_item$query$feature = item.query.feature) === null || _item$query$feature === void 0 ? void 0 : _item$query$feature.name.toLowerCase().includes(lowerCaseQuery)) || ((_item$query$feature2 = item.query.feature) === null || _item$query$feature2 === void 0 ? void 0 : (_item$query$feature2$ = _item$query$feature2.name) === null || _item$query$feature2$ === void 0 ? void 0 : _item$query$feature2$.toLowerCase().includes(lowerCaseQuery)) || item.query.kql.query.toLowerCase().includes(lowerCaseQuery);
      });
    }
    return response !== null && response !== void 0 ? response : [];
  }, [response, queryString]);
  // calculate a combined query for all items
  const combinedQuery = (0, _react.useMemo)(() => {
    if (significantEvents.length === 0) {
      return null;
    }
    const queries = significantEvents.map(item => `(${item.query.kql.query})`);
    return queries.join(' OR ');
  }, [significantEvents]);
  return {
    significantEvents,
    combinedQuery
  };
};
exports.useFilteredSigEvents = useFilteredSigEvents;