"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsList = StreamsList;
exports.asTrees = asTrees;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _css = require("@emotion/css");
var _streamsSchema = require("@kbn/streams-schema");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _nested_view = require("../nested_view");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/streams_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function asTrees(streams) {
  const trees = [];
  const sortedStreams = streams.slice().sort((a, b) => (0, _streamsSchema.getSegments)(a.name).length - (0, _streamsSchema.getSegments)(b.name).length);
  sortedStreams.forEach(stream => {
    let currentTree = trees;
    let existingNode;
    // traverse the tree following the prefix of the current name.
    // once we reach the leaf, the current name is added as child - this works because the ids are sorted by depth
    while (existingNode = currentTree.find(node => (0, _streamsSchema.isDescendantOf)(node.name, stream.name))) {
      currentTree = existingNode.children;
    }
    if (!existingNode) {
      const newNode = {
        name: stream.name,
        children: [],
        stream,
        type: _streamsSchema.Streams.ClassicStream.Definition.is(stream) ? 'classic' : (0, _streamsSchema.isRootStreamDefinition)(stream) ? 'root' : 'wired'
      };
      currentTree.push(newNode);
    }
  });
  return trees;
}
function StreamsList({
  streams,
  query,
  showControls
}) {
  const [collapsed, setCollapsed] = _react.default.useState({});
  const [showClassic, setShowClassic] = _react.default.useState(true);
  const items = (0, _react.useMemo)(() => {
    return streams !== null && streams !== void 0 ? streams : [];
  }, [streams]);
  const filteredItems = (0, _react.useMemo)(() => {
    return items.filter(item => showClassic || _streamsSchema.Streams.WiredStream.Definition.is(item)).filter(item => !query || item.name.toLowerCase().includes(query.toLowerCase()));
  }, [query, items, showClassic]);
  const treeView = (0, _react.useMemo)(() => asTrees(filteredItems), [filteredItems]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, showControls && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamsTable.tableTitle', {
    defaultMessage: 'Streams'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, Object.keys(collapsed).length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppStreamsListCollapseAllButton",
    iconType: "fold",
    size: "s",
    onClick: () => setCollapsed(Object.fromEntries(items.map(item => [item.name, true]))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.streams.streamsTable.collapseAll', {
    defaultMessage: 'Collapse all'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppStreamsListExpandAllButton",
    iconType: "unfold",
    onClick: () => setCollapsed({}),
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.streams.streamsTable.expandAll', {
    defaultMessage: 'Expand all'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.streams.streamsTable.showClassicStreams', {
      defaultMessage: 'Show classic streams'
    }),
    compressed: true,
    checked: showClassic,
    onChange: e => setShowClassic(e.target.checked),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, treeView.map(tree => /*#__PURE__*/_react.default.createElement(StreamNode, {
    key: tree.name,
    node: tree,
    collapsed: collapsed,
    setCollapsed: setCollapsed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }))));
}
function StreamNode({
  node,
  collapsed,
  setCollapsed
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const discoverLocator = (0, _react.useMemo)(() => share.url.locators.get('DISCOVER_APP_LOCATOR'), [share.url.locators]);
  const discoverUrl = (0, _react.useMemo)(() => {
    const indexPatterns = (0, _streamsSchema.getIndexPatternsForStream)(node.stream);
    if (!discoverLocator || !indexPatterns) {
      return undefined;
    }
    return discoverLocator.getRedirectUrl({
      query: {
        esql: `FROM ${indexPatterns.join(', ')}`
      }
    });
  }, [discoverLocator, node]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    className: (0, _css.css)`
        margin-top: ${_uiTheme.euiThemeVars.euiSizeXS};
        margin-left: ${_uiTheme.euiThemeVars.euiSizeS};
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    className: (0, _css.css)`
          padding: ${_uiTheme.euiThemeVars.euiSizeXS};
          border-radius: ${_uiTheme.euiThemeVars.euiBorderRadius};
          &:hover {
            background-color: ${_uiTheme.euiThemeVars.euiColorLightestShade};
            .links {
              opacity: 1;
            }
          }
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }, node.children.length > 0 &&
  /*#__PURE__*/
  // Using a regular button here instead of the EUI one to control styling
  _react.default.createElement("button", {
    type: "button",
    onClick: () => {
      setCollapsed === null || setCollapsed === void 0 ? void 0 : setCollapsed({
        ...collapsed,
        [node.name]: !(collapsed !== null && collapsed !== void 0 && collapsed[node.name])
      });
    },
    className: (0, _css.css)`
              background: none;
              margin-left: -${_uiTheme.euiThemeVars.euiSizeXS};
              margin-right: ${_uiTheme.euiThemeVars.euiSizeXS};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: collapsed !== null && collapsed !== void 0 && collapsed[node.name] ? 'arrowRight' : 'arrowDown',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "streamsAppStreamNodeLink",
    color: "text",
    href: router.link('/{key}', {
      path: {
        key: node.name
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }, node.name), node.type === 'root' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "branch",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  })), node.type === 'classic' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "bullseye",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: `links ${(0, _css.css)`
            opacity: 0;
          `}`,
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.streams.streamsTable.openInNewTab', {
      defaultMessage: 'Open in new tab'
    }),
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppStreamNodeButton",
    "aria-label": _i18n.i18n.translate('xpack.streams.streamsTable.openInNewTab', {
      defaultMessage: 'Open in new tab'
    }),
    iconType: "popout",
    target: "_blank",
    href: router.link('/{key}', {
      path: {
        key: node.name
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.streams.streamsTable.openInDiscover', {
      defaultMessage: 'Open in Discover'
    }),
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppStreamNodeButton",
    iconType: "discoverApp",
    href: discoverUrl,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamsTable.openInDiscover', {
      defaultMessage: 'Open in Discover'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.streams.streamsTable.management', {
      defaultMessage: 'Management'
    }),
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppStreamNodeButton",
    iconType: "gear",
    "aria-label": _i18n.i18n.translate('xpack.streams.streamsTable.management', {
      defaultMessage: 'Management'
    }),
    href: router.link('/{key}/management/{tab}', {
      path: {
        key: node.name,
        tab: 'partitioning'
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 13
    }
  })))), node.children.length > 0 && !(collapsed !== null && collapsed !== void 0 && collapsed[node.name]) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 11
    }
  }, node.children.map((child, index) => /*#__PURE__*/_react.default.createElement(_nested_view.NestedView, {
    key: child.name,
    last: index === node.children.length - 1,
    first: index === 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(StreamNode, {
    node: child,
    collapsed: collapsed,
    setCollapsed: setCollapsed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 17
    }
  }))))));
}